<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class PageTableVerify{
	var $valid = true;

	function PageTableVerify(){
	}
	function verify($tableObject){
		$this->verifyId($tableObject->getId());
		$this->verifyTitle($tableObject->getTitle());
		$this->verifyUrl($tableObject->getUrl());
		$this->verifyUpdateDate($tableObject->getUpdateDate());
		$this->verifyRegistDate($tableObject->getRegistDate());
		$this->verifyDescription($tableObject->getDescription());
		$this->verifyCount($tableObject->getCount());
		$this->verifyTags($tableObject->getTags());
		return $this->valid;	
	}
	function verifyId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedId())),$this->_validName("id"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedId())),$this->_validName("id"));
		}
		unset($value);
	}
	function verifyTitle($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedTitle())),$this->_validName("title"));
		}
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTitle(),1000)),$this->_validName("title"));
		}
		unset($value);
	}
	function verifyUrl($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUrl())),$this->_validName("url"));
		}
		if(!empty($value) && !Validate::isString($value,0,2000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedUrl(),2000)),$this->_validName("url"));
		}
		unset($value);
	}
	function verifyUpdateDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUpdateDate())),$this->_validName("updateDate"));
		}
		unset($value);
	}
	function verifyRegistDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedRegistDate())),$this->_validName("registDate"));
		}
		unset($value);
	}
	function verifyDescription($value){
		if(!empty($value) && !Validate::isString($value,0,6000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedDescription(),6000)),$this->_validName("description"));
		}
		unset($value);
	}
	function verifyCount($value){
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedCount())),$this->_validName("count"));
		}
		unset($value);
	}
	function verifyTags($value){
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTags(),1000)),$this->_validName("tags"));
		}
		unset($value);
	}

	function namedId(){
		return Message::_("ID");
	}
	function namedTitle(){
		return Message::_("TITLE");
	}
	function namedUrl(){
		return Message::_("URL");
	}
	function namedUpdateDate(){
		return Message::_("UPDATE_DATE");
	}
	function namedRegistDate(){
		return Message::_("REGIST_DATE");
	}
	function namedDescription(){
		return Message::_("DESCRIPTION");
	}
	function namedCount(){
		return Message::_("COUNT");
	}
	function namedTags(){
		return Message::_("TAGS");
	}
	function _validName($name){
		$this->valid = false;
		return "Page_".$name;
	}
}

?>