<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class PageFeedTableVerify{
	var $valid = true;

	function PageFeedTableVerify(){
	}
	function verify($tableObject){
		$this->verifyPageId($tableObject->getPageId());
		$this->verifyFeedId($tableObject->getFeedId());
		return $this->valid;	
	}
	function verifyPageId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedPageId())),$this->_validName("pageId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedPageId())),$this->_validName("pageId"));
		}
		unset($value);
	}
	function verifyFeedId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedFeedId())),$this->_validName("feedId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedFeedId())),$this->_validName("feedId"));
		}
		unset($value);
	}

	function namedPageId(){
		return Message::_("PAGE_ID");
	}
	function namedFeedId(){
		return Message::_("FEED_ID");
	}
	function _validName($name){
		$this->valid = false;
		return "PageFeed_".$name;
	}
}

?>