<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.PageFeedVerify");
Rhaco::importLibrary("data.Page");
Rhaco::importLibrary("data.Feed");
class PageFeedTable extends TableObjectBase{
	var $pageId;
	var $feedId;
	function PageFeedTable(
		$pageId=null
		,$feedId=null
	){
		$this->pageId = 0;
		$this->feedId = 0;
		$this->setPageId($pageId);
		$this->setFeedId($feedId);
	}
	function setPageId($value){
		$this->pageId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getPageId(){
		return $this->pageId;
	}
	function setFeedId($value){
		$this->feedId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getFeedId(){
		return $this->feedId;
	}
	function columnPageId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE_FEED","PAGE_FEED"),"PAGE_ID","PageId","INTEGER");
	}
	function columnFeedId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."PAGE_FEED","PAGE_FEED"),"FEED_ID","FeedId","INTEGER");
	}
	function referencePageId(){
		return array(new Page(),Page::columnId(),$this->getPageId());
	}
	function referenceFeedId(){
		return array(new Feed(),Feed::columnId(),$this->getFeedId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Page::columnId(),
			PageFeed::columnPageId()
		);
		$criteria->add(
			Feed::columnId(),
			PageFeed::columnFeedId()
		);
		return $criteria;
	}
	function criteriaPageId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Page::columnId(),
			$this->getPageId()
		);
		return $criteria;
	}
	function criteriaFeedId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			Feed::columnId(),
			$this->getFeedId()
		);
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new PageFeedVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new PageFeedVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(PageFeed::columnPageId(),PageFeed::columnFeedId(),);
	}
	function primaryKey(){
		return array(PageFeed::columnPageId(),PageFeed::columnFeedId(),);
	}
}
?>