<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class MemoryTableVerify{
	var $valid = true;

	function MemoryTableVerify(){
	}
	function verify($tableObject){
		$this->verifyUserId($tableObject->getUserId());
		$this->verifyTitle($tableObject->getTitle());
		$this->verifyUrl($tableObject->getUrl());
		$this->verifyRegistDate($tableObject->getRegistDate());
		return $this->valid;	
	}
	function verifyUserId($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUserId())),$this->_validName("userId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedUserId())),$this->_validName("userId"));
		}
		unset($value);
	}
	function verifyTitle($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedTitle())),$this->_validName("title"));
		}
		if(!empty($value) && !Validate::isString($value,0,1000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedTitle(),1000)),$this->_validName("title"));
		}
		unset($value);
	}
	function verifyUrl($value){
		if($value === "" || $value === null){
			ExceptionTrigger::raise(new RequireException(array($this->namedUrl())),$this->_validName("url"));
		}
		if(!empty($value) && !Validate::isString($value,0,2000)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedUrl(),2000)),$this->_validName("url"));
		}
		unset($value);
	}
	function verifyRegistDate($value){
		if(!empty($value) && !Validate::isTimestamp($value)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedRegistDate())),$this->_validName("registDate"));
		}
		unset($value);
	}

	function namedUserId(){
		return Message::_("USER_ID");
	}
	function namedTitle(){
		return Message::_("TITLE");
	}
	function namedUrl(){
		return Message::_("URL");
	}
	function namedRegistDate(){
		return Message::_("REGIST_DATE");
	}
	function _validName($name){
		$this->valid = false;
		return "Memory_".$name;
	}
}

?>