<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");
Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.DbConnectionGoesby");
Rhaco::importLibrary("data.verify.MemoryVerify");
Rhaco::importLibrary("data.UserLogin");
class MemoryTable extends TableObjectBase{
	var $userId;
	var $title;
	var $url;
	var $registDate;
	function MemoryTable(
	){
		$this->userId = 0;
		$this->title = null;
		$this->url = null;
		$this->registDate = time();
	}
	function setUserId($value){
		$this->userId = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getUserId(){
		return $this->userId;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setUrl($value){
		$this->url = $value;
	}
	function getUrl(){
		return $this->url;
	}
	function setRegistDate($value){
		if(!empty($value) && !is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d H:i:s"){
		return date($format,$this->registDate);
	}
	function columnUserId(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."MEMORY","MEMORY"),"USER_ID","UserId","INTEGER");
	}
	function columnTitle(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."MEMORY","MEMORY"),"TITLE","Title","STRING");
	}
	function columnUrl(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."MEMORY","MEMORY"),"URL","Url","STRING");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_goesby_PREFIX")."MEMORY","MEMORY"),"REGIST_DATE","RegistDate","TIMESTAMP");
	}
	function referenceUserId(){
		return array(new UserLogin(),UserLogin::columnId(),$this->getUserId());
	}
	function related($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			Memory::columnUserId()
		);
		return $criteria;
	}
	function criteriaUserId($criteria=null){
		if(!Variable::isClassType(Criteria,$criteria)){
			$criteria = new Criteria();
		}
		$criteria->add(
			UserLogin::columnId(),
			$this->getUserId()
		);
		return $criteria;
	}
	function unique(){
		return array(
			);
	}
	function verifyObject(){
		return new MemoryVerify();
	}
	function connection(){
		return new DbConnectionGoesby();
	}
	function beforeDelete($dbUtil,$criteria){
		if(Variable::isClassType(DbUtil,$dbUtil)){
		}
		unset($dbUtil,$criteria);
	}
	function verify(){
		$verify = new MemoryVerify();
		return $verify->verify($this);
	}
	function columns(){
		return array(Memory::columnUserId(),Memory::columnTitle(),Memory::columnUrl(),Memory::columnRegistDate(),);
	}
	function primaryKey(){
		return array();
	}
}
?>