<?php
require_once("./__init__.php");
Rhaco::import("network.http.Request");
Rhaco::import("tag.feed.Opml");
Rhaco::import("tag.feed.Rss20");
Rhaco::import("util/Pager");
Rhaco::importLibrary("BookmarkController");

$request 	= new Request();
$BLOCK_LIST	= array_merge($BLOCK_LIST,array("block/bookmarkList.html","block/bookmark_search.html","block/player.html","block/pager.html"));
$query		= Variable::hashConvObject($request->getVariable(),new Query(Variable::toArray($request->getUrlMap(),1)));$query->setOffset($request->getVariable("offset",0));
$query->setLimit($request->getVariable("limit",0));

list($bookmarkList) = BookmarkController::search($request->getUrlMap(0),$query);

if($request->getVariable("type","opml") == "rss"){
	$feed = new Rss20();
	$feed->setChannel("goesby - ".$request->getUrlMap(0));
	
	foreach($bookmarkList as $bookmark){
		$item = new RssItem20($bookmark->getTitle(),implode(" ",$bookmark->getTagList()),$bookmark->getUrl());
		$item->setComments($bookmark->getComment());
		$item->setAuthor($request->getUrlMap(0));
		$item->setCategory($item->getDescription);
		$feed->setItem($item);
	}
}else{
	$feed = new Opml();
	$feed->setOwnerName($request->getUrlMap(0));
	$feed->setTitle("goesby - ".$request->getUrlMap(0));
	
	foreach($bookmarkList as $bookmark){
		$feed->setOutline(Variable::hashConvObject(
								array(	"title"=>$bookmark->getTitle(),
										"text"=>$bookmark->getTitle(),
										"htmlUrl"=>$bookmark->getUrl(),
										"description"=>implode(" ",$bookmark->getTagList()),
										"value"=>$bookmark->getComment(),
										"type"=>"bookmark"
								),
								new OpmlOutline()
							)
						);
	}
}
Header::requestAttachment(new File("export.xml",$feed->output()));
?>