<?php
require_once("./__init__.php");
Rhaco::import("network.http.Request");
Rhaco::import("tag.HtmlParser");
Rhaco::import("util.Pager");
Rhaco::importLibrary("BookmarkController");
Rhaco::importLibrary("UserController");
Rhaco::importLibrary("DbUtilGoesby");

$request 	= new Request();
$template	= new HtmlParser();
$dbUtil		= DbUtilGoesby::instance($dbUtil);
$BLOCK_LIST	= array_merge($BLOCK_LIST,array("block/bookmarkList.html","block/user_menu.html","block/player.html","block/pager.html","block/user_contents.html"));
$query		= Variable::hashConvObject($request->getVariable(),new Query(Variable::toArray($request->getUrlMap(),1)));
$query->setOffset($request->getVariable("offset",0));
$query->setLimit(Rhaco::define("LIST_MAX_COUNT",30));

list($bookmarkList,$playList,$count) = BookmarkController::search($request->getUrlMap(0),$query,$dbUtil);

if($LOGIN != $request->getUrlMap(0)){
	$BLOCK_LIST = array_merge($BLOCK_LIST,array("block/no_owner.html"));
}
$template->setVariable($request->getVariable());
$template->setVariable("title",$request->getUrlMap(0));
$template->setVariable("userDetail",UserController::get($request->getUrlMap(0),$dbUtil));
$template->setVariable("pager",new Pager($count,$query->getLimit(),$query->getOffset()));
$template->setVariable("bookmarkList",$bookmarkList);
$template->setVariable("playList",$playList);
$template->setVariable("keyword",trim(implode(" ",Variable::toArray($request->getUrlMap(),1))." ".$request->getVariable("keyword")));
$template->setVariable($VARIABLE_LIST);
$template->setBlock($BLOCK_LIST);
$template->write("index.html");
?>