<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Atom.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomAuthor.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomLink.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/AtomEntry03.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class Atom03 extends Atom{
	var $version = "0.3";
	var $title;
	var $modified;

	var $link;
	var $author;
	var $entryList = array();
	
	function Atom03(){
	}
	function set($src){
		$tag = new SimpleTag();

		if(!$tag->set($src,"feed")){	
			return false;
		}
		if($tag->getParameter("version") != "0.3"){
			return false;
		}
		foreach($tag->getIn("entry") as $intag){
			$data = new AtomEntry03();
			$data->set($intag->get());
			$this->entryList[] = $data;

			$src = str_replace($intag->getPlain(),"",$src);
		}
		$tag->set($src,"feed");
		$this->setVersion($tag->getParameter("version"));

		foreach($tag->getIn("title") as $intag){
			$this->setTitle($intag->getValue());
		}
		foreach($tag->getIn("modified") as $intag){
			$this->setModified($intag->getValue());
		}
		foreach($tag->getIn("author") as $intag){
			$data = new AtomAuthor();
			$data->set($intag->get());
			$this->setAuthor($data);
		}
		foreach($tag->getIn("link") as $intag){
			$data = new AtomLink();
			$data->set($intag->get());
			$this->setLink($data);
		}
		return true;
	}
	function get(){
		$outTag	= new SimpleTag("feed");
		$outTag->setParameter("version",$this->getVersion());
		$outTag->setParameter("xmlns","http://purl.org/atom/ns#");

		$tag = new SimpleTag("title",$this->getTitle());
		$outTag->addValue($tag->get());
		
		if(intval($this->modified) > 0){
			$tag = new SimpleTag("modified",$this->getModified());
			$outTag->addValue($tag->get());
		}		
		if(Variable::isClassType(AtomAuthor,$this->getAuthor())){
			$data = $this->getAuthor();
			$outTag->addValue($data->get());
		}
		if(Variable::isClassType(AtomLink,$this->getLink())){
			$data = $this->getLink();
			$outTag->addValue($data->get());
		}
		foreach($this->entryList as $data){
			if(Variable::isClassType(AtomEntry03,$data)){
				$outTag->addValue($data->get());
			}
		}				
		return $outTag->get();
	}
	function setVersion($value){
		$this->version = $value;
	}
	function getVersion(){
		return $this->version;
	}
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setModified($value){
		$this->modified = DateUtil::parseString($value);
	}
	function getModified(){
		return DateUtil::formatW3C($this->modified);
	}
	function setAuthor($value){
		if(!Variable::isClassType(AtomAuthor,$value)){
			$author = new AtomAuthor();
			$author->set($value);
			$value = $author;
		}
		$this->author = $value;
	}
	function getAuthor(){
		if(Variable::isClassType(AtomAuthor,$this->author)){
			return $this->author;
		}
		return new AtomAuthor();
	}
	function setLink($value){
		$this->link = $value;
	}
	function getLink(){
		return $this->link;
	}
	function getLinkHref(){
		foreach($this->link as $link){
			return $link->getHref();
		}
		return "";
	}	
	function getEntry(){
		return $this->entryList;
	}
	function setEntry($title,$summary="",$content=""){
		$this->entryList[] = new AtomEntry03($title,$summary,$content);
	}
}
?>