<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class SimpleTagParser{
	function parse(&$tag){
		if(Variable::isClassType(SimpleTag,$tag)){
			if(trim($tag->plain) != ""){
				$value			= $tag->plain;
				$name			= $tag->getName();
				$parse			= array();
				$startTagList	= array();
				$endTagList		= array();

				if(preg_match("/(<(".$name.")([\s\t][^>]*)?>)/is",$value,$parse)){
					if(substr($parse[1],-2) == "/>"){
						$tag->setName($parse[2]);
						$tag->plain = $parse[1];
						SimpleTagParser::parseParameterAttribute($tag,$parse[3]);
						return true;
					}else{
						$value			= substr($value,strpos($value,$parse[1]));
						$startTagList	= array();
						$endTagList		= array();
	
						if(preg_match_all("/(<\/".$name.">?)/is",$value,$endTagList)){
							if(preg_match_all("/(<".$name."[\s\t]([^>]*[^\/])?>)|(<".$name."?>)/is",$value,$startTagList)){
								$endTagLength	= array();
								$lineList		= array();
								$first			= 0;
								$balance			= 0;
	
								for($i=0,$offset=0;sizeof($startTagList[0])>$i;$i++,$offset++){
									$offset				= strpos($value,$startTagList[0][$i],$offset);
									$lineList[$offset]	= 1;
			
									if($i == 0){
										$first = $offset;
									}
								}
								for($i=0,$offset=$first;sizeof($endTagList[1])>$i;$i++,$offset++){
									$offset					= strpos($value,$endTagList[1][$i],$offset);
									$lineList[$offset]		= -1;
									$endTagLength[$offset]	= strlen($endTagList[1][$i]);
								}
								ksort($lineList);
								foreach($lineList as $line => $point){
									if(($balance += $point) == 0){
										$str = substr($value,$first,$line+$endTagLength[$line]-$first);
	
										if(preg_match("/((<[\s\t]*(".$name.")([\s\t]*[^>]*)>)(.*)(<[\s]*\/\\3[\s\t]*>))/is",$str,$parse)){
											$tag->setName($parse[3]);
											$tag->setValue($parse[5]);
											$tag->plain = $parse[1];
											SimpleTagParser::parseParameterAttribute($tag,$parse[4]);
											return true;
										}
									}
								}
							}
						}
					}
				}
			}
		}
		return false;
	}
	function parseParameterAttribute(&$tag,$src){
		$parameter = array();
		$attribute = array();

		if(!empty($src)){
			if(preg_match_all("/[\s\t]+([\w\d\_\-\:]+)[\s\t]*=[\s\t]*([\"\'])([^\\2]*?)\\2/ms",$src,$parameter)){
				foreach($parameter[0] as $id => $value){
					$tag->setParameter($parameter[1][$id],$parameter[3][$id]);
					$src = str_replace($value,"",$src);
				}
			}
			if(preg_match_all("/([\w\d\_\-]+)/",$src,$attribute)){
				foreach($attribute[1] as $value){
					$tag->setAttribute($value);
				}
			}
		}
	}
	function xhtmlnize($src,$name){
		if(preg_match_all(sprintf("/<%s(.+?)>/is",$name),$src,$link)){
			foreach($link[0] as $value){
				if(substr($value,-2) != "/>"){
					$src = str_replace($value,substr($value,0,-1)."/>",$src);
				}
			}
		}
		return $src;
	}
}
?>