<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Opml");
Rhaco::import("io.FileUtil");

class OpmlTest extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Opml();
		$src = File::read(Rhaco::resource("export.opml"));

		$feed->set($src);
		$this->_assert($feed);
	}
	function testGet(){
		$feed = new Opml();
		$src = File::read(Rhaco::resource("export.opml"));
		$feed->set($src);
		
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/OpmlResult.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/OpmlResult.xml")),$feed->get());
	}
	function _assert($feed){
		$this->assertEquals("Bloglines Subscriptions",$feed->getTitle());
		$this->assertEquals(2,sizeof($feed->getOutline()));
		foreach($feed->getOutline() as $item){
			$this->assertTrue(Variable::isClassType(OpmlOutline,$item));
			$this->assertTrue(
					(strlen($item->getText()) > 0) || 
					(strlen($item->getHtmlUrl()) > 0)
				);
		}
	}
	function testItems(){
		$feed = new Opml();
		$src = File::read(Rhaco::resource("export.opml"));
		$feed->set($src);
		
		$items = $feed->getHtmlOutlines();
		$this->assertEquals(3,sizeof($items));
	}
}
?>