<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.TagUtil");
Rhaco::import("io.FileUtil");
Rhaco::importLibrary("ClassDummy");

class TagUtilTest extends UnitTest{
	var $tagUtil;
	var $fileUtil;
	
	function setUp(){
		$this->fileUtil = new FileUtil();
		$this->tagUtil = new TagUtil();		
		
		$tag = new SimpleTag("root");

		$intag = new SimpleTag("parent");
		$intag->setParameter("id",1);
		$intag->setParameter("abc","ABC");
		$intag->addTag(new SimpleTag("data1","abc"));
		$intag->addTag(new SimpleTag("data2","def"));
		$intag->addTag(new SimpleTag("data3","ghi"));
		$tag->addValue($intag->get());

		$intag = new SimpleTag("parent");
		$intag->setParameter("id",2);
		$intag->setParameter("abc","XYZ");		
		$intag->addTag(new SimpleTag("data1","jkl"));
		$intag->addTag(new SimpleTag("data2","mno"));
		$intag->addTag(new SimpleTag("data3","pqr"));
		$tag->addValue($intag->get());
		
		$this->fileUtil->write(Rhaco::templatepath("tag/tagUtilData.xml"),$tag->get());
	}
    function tearDown(){
		$this->tagUtil->close(Rhaco::templatepath("tag/tagUtilData.xml"));
		$this->fileUtil->rm(Rhaco::templatepath("tag/tagUtilData.xml"));
	}
	function testSelect(){
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(2,sizeof($list));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("data1"));
		$this->assertEquals(2,sizeof($list));		

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("data1","abc"));
		$this->assertEquals(1,sizeof($list));

		$tag = new SimpleTag("parent");
		$tag->setParameter("id",2);

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		$this->assertEquals(1,sizeof($list));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"),1,0);
		$this->assertEquals(1,sizeof($list));
		$this->assertEquals(1,$list[0]->getParameter("id"));
	}
	function testCount(){
		$this->assertEquals(2,$this->tagUtil->count(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent")));
		$this->assertEquals(1,$this->tagUtil->count(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("data1","abc")));
	}
	function testGet(){
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		$this->assertTrue(Variable::isClassType(SimpleTag,$gettag));
		
		if(Variable::isClassType(SimpleTag,$gettag)){
			$this->assertEquals(2,$gettag->getParameter("id"));
		}
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertTrue(Variable::isClassType(SimpleTag,$gettag));
	}

	function testInsert(){
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",3);
		$tag->addTag(new SimpleTag("data1","123"));
		$tag->addTag(new SimpleTag("data2","456"));
		$tag->addTag(new SimpleTag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(3,sizeof($list));
	}
	function testUpdate(){
		$contag = new SimpleTag("parent");
		$contag->setParameter("id",2);
		
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",2);
		$tag->addTag(new SimpleTag("data1","123"));
		$tag->addTag(new SimpleTag("data2","456"));
		$tag->addTag(new SimpleTag("data3","789"));		
		$this->tagUtil->update(Rhaco::templatepath("tag/tagUtilData.xml"),$tag,$contag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(2,sizeof($list));		
		
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		$this->assertTrue(Variable::isClassType(SimpleTag,$gettag));
		
		if(Variable::isClassType(SimpleTag,$gettag)){
			$data1 = $gettag->getIn("data1"); 
			$data2 = $gettag->getIn("data2");		
			$data3 = $gettag->getIn("data3");
			
			$this->assertEquals("123",$data1[0]->getValue());
			$this->assertEquals("456",$data2[0]->getValue());
			$this->assertEquals("789",$data3[0]->getValue());
		}
	}
	function testDelete(){
		$contag = new SimpleTag("parent");
		$contag->setParameter("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(1,sizeof($list));		
	}
	function testTransaction(){
		$this->tagUtil->setTransaction(true);

		$contag = new SimpleTag("parent");
		$contag->setParameter("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		$this->tagUtil->rollback(Rhaco::templatepath("tag/tagUtilData.xml"));

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(2,sizeof($list));
		
		$contag = new SimpleTag("parent");
		$contag->setParameter("id",2);
		$this->tagUtil->delete(Rhaco::templatepath("tag/tagUtilData.xml"),$contag);
		$this->tagUtil->commit(Rhaco::templatepath("tag/tagUtilData.xml"));
		
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		$this->assertEquals(1,sizeof($list));
	}
	
	function testGetIn(){
		$src = $this->fileUtil->read(Rhaco::templatepath("tag/tagUtilData.xml"));
		$tag = new SimpleTag();
		$tag->set($src,"root");
		
		$list = $this->tagUtil->getIn($tag,new SimpleTag("data1","abc"));
		$this->assertEquals(1,sizeof($list));		
		
		$list = $this->tagUtil->getIn($tag,new SimpleTag("data1"));
		$this->assertEquals(2,sizeof($list));
	}
	function testGetNotIn(){
		$src = $this->fileUtil->read(Rhaco::templatepath("tag/tagUtilData.xml"));
		$tag = new SimpleTag();
		$tag->set($src,"root");
		
		$list = $this->tagUtil->getNotIn($tag,new SimpleTag("data1","abc"));
		$this->assertEquals(1,sizeof($list));		

		$list = $this->tagUtil->getNotIn($tag,new SimpleTag("data1"));
		$this->assertEquals(0,sizeof($list));

		$list = $this->tagUtil->getNotIn($tag,new SimpleTag("hoge"));
		$this->assertEquals(0,sizeof($list));

		$list = $this->tagUtil->getNotIn($tag,new SimpleTag("data2","mno"));
		$this->assertEquals(1,sizeof($list));			
	}
	function testIsTagfile(){
		$this->assertTrue($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilData.xml"),"root"));
		$this->assertFalse($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilData.xml"),"boot"));
		$this->assertTrue($this->tagUtil->isTagfile(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"),"root",true));	

		$this->tagUtil->close(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"));		
		$this->fileUtil->rm(Rhaco::templatepath("tag/tagUtilIsTagFile.xml"));
	}
	function testSort(){
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",4);
		$tag->addTag(new SimpleTag("data1","123"));
		$tag->addTag(new SimpleTag("data2","456"));
		$tag->addTag(new SimpleTag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);
		
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",3);
		$tag->addTag(new SimpleTag("data1","123"));
		$tag->addTag(new SimpleTag("data2","456"));
		$tag->addTag(new SimpleTag("data3","789"));		
		$this->tagUtil->insert(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);

		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		
		$count = 1;
		foreach($list as $tag){
			if($count == 3){
				$this->assertEquals(4,$tag->getParameter("id"));
				break;
			}
			$count++;
		}
		$list = $this->tagUtil->sort($list,"id");

		$count = 1;
		foreach($list as $tag){
			if($count == 3){
				$this->assertEquals(3,$tag->getParameter("id"));
				break;
			}
			$count++;
		}
	}
	function testRSort(){
		$list = $this->tagUtil->select(Rhaco::templatepath("tag/tagUtilData.xml"),new SimpleTag("parent"));
		
		foreach($list as $tag){
			$this->assertEquals(1,$tag->getParameter("id"));
			break;
		}
		$list = $this->tagUtil->rsort($list,"id");		
		foreach($list as $tag){
			$this->assertEquals(2,$tag->getParameter("id"));
			break;		
		}
	}
	function testToObject(){
		$tag = new SimpleTag("parent");
		$tag->setParameter("id",2);
		$gettag = $this->tagUtil->get(Rhaco::templatepath("tag/tagUtilData.xml"),$tag);

		$newobj = $this->tagUtil->toObject($gettag,new ClassDummy());
		$this->assertTrue(Variable::isClassType(ClassDummy,$newobj));
		$this->assertEquals("XYZ",$newobj->getAbc());
	}
}
?>