<?php
Rhaco::import("database.data.TableObjectBase");
Rhaco::import("database.data.Column");
Rhaco::import("database.data.Table");
Rhaco::import("database.data.Criteria");
Rhaco::import("lang.StringUtil");

Rhaco::import("lang.DateUtil");
Rhaco::importLibrary("data.verify.PersonVerify");
Rhaco::importLibrary("data.Address");
class PersonTable extends TableObjectBase{
	var $id;
	var $name;
	var $age;
	var $flag;
	var $registDate;

	function PersonTable(
		$id=null
	){
		$this->id = 0;
		$this->name = null;
		$this->age = 0;
		$this->flag = null;
		$this->registDate = time();
		$this->setId($id);
	}

	function setId($value){
		$this->id = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getId(){
		return $this->id;
	}
	function setName($value){
		$this->name = $value;
	}
	function getName(){
		return $this->name;
	}
	function setAge($value){
		$this->age = sprintf("%d",StringUtil::convertZenhan($value));
	}
	function getAge(){
		return $this->age;
	}
	function setFlag($value){
		$this->flag = $value;
	}
	function getFlag(){
		return $this->flag;
	}
	function setRegistDate($value){
		if(!is_numeric($value)){
			$value = DateUtil::parseString(StringUtil::convertZenhan($value));
		}
		$this->registDate = $value;
	}
	function getRegistDate(){
		return $this->registDate;
	}
	function formatRegistDate($format="Y/m/d"){
		return date($format,$this->registDate);
	}
	
	function columnId(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"ID","Id","SERIAL");
	}
	function columnName(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"NAME","Name","STRING");
	}
	function columnAge(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"AGE","Age","INTEGER");
	}
	function columnFlag(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"FLAG","Flag","BOOLEAN");
	}
	function columnRegistDate(){
		return new Column(new Table(Rhaco::define("DATABASE_rhacotest_PREFIX")."PERSON","PERSON"),"REGIST_DATE","RegistDate","DATE");
	}

	function __columns(){
		return array(
				$this->columnId()
				,$this->columnName()
				,$this->columnAge()
				,$this->columnFlag()
				,$this->columnRegistDate()
				);
	}
	function __primaryKey(){
		return array(	
				$this->columnId()
				);
	}
	function dependColumnId(){
		$list	= array();
	
		$criteria = new Criteria();
		$criteria->add(Address::columnPersonId(),$this->getId());
		$list[] = array(new Address(),$criteria);
		
		return $list;
	}
	function related($criteria=null){
		if(!preg_match("/Criteria/i",get_class($criteria))){		
			$criteria = new Criteria();
		}
		
		return $criteria;
	}
	function __verify(){
		$verify = new PersonVerify();
		return $verify->verify($this);
	}
}
?>