<?php
Rhaco::import("lang.Validate");
Rhaco::import("exception.ExceptionTrigger");
Rhaco::import("exception.data.MaxLengthException");
Rhaco::import("exception.data.RequireException");
Rhaco::import("exception.data.DataTypeException");
Rhaco::import("resources.Message");

class AddressTableVerify{
	var $valid = true;

	function AddressTableVerify(){
	}
	function verify($tableObject){
		$this->verifyPersonId($tableObject->getPersonId());
		$this->verifyEmail($tableObject->getEmail());
		return $this->valid;	
	}
	function verifyPersonId($value){
		if($value == "" || $value == null){
			ExceptionTrigger::raise(new RequireException(array($this->namedPersonId())),$this->_validName("personId"));
		}
		if(!empty($value) && !Validate::isIntegerLength($value,22)){
			ExceptionTrigger::raise(new DataTypeException(array($this->namedPersonId())),$this->_validName("personId"));
		}
		unset($value);
	}
	function verifyEmail($value){
		if($value == "" || $value == null){
			ExceptionTrigger::raise(new RequireException(array($this->namedEmail())),$this->_validName("email"));
		}
		if(!empty($value) && !Validate::isString($value,0,100)){
			ExceptionTrigger::raise(new MaxLengthException(array($this->namedEmail(),100)),$this->_validName("email"));
		}
		unset($value);
	}

	function namedPersonId(){
		return Message::_("PERSON_ID");
	}
	function namedEmail(){
		return Message::_("EMAIL");
	}
	function _validName($name){
		$this->valid = false;
		return "Address_".$name;
	}
}

?>