<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/RssChannel.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.1.2
 */
class RssChannel10 extends RssChannel{
	var $about = "";
	var $imageList = array();
	var $itemsList = array();
	var $textinputList = array();

	function RssChannel10($title="",$description="",$link="",$about=""){
		parent::RssChannel($title,$description,$link);		
		$this->setAbout($about);
	}
	function _set($tag){
		parent::_set($tag);

		$this->setAbout($tag->getParameter("rdf:about"));
		
		foreach($tag->getIn("image") as $intag){
			$this->setImage($intag->getParameter("rdf:resource"));
		}
		foreach($tag->getIn("textinput") as $intag){
			$this->setTextinput($intag->getParameter("rdf:resource"));
		}
		foreach($tag->getIn("items") as $intag){
			foreach($intag->getIn("rdf:Seq") as $inintag){
				foreach($inintag->getIn("rdf:li") as $ininintag){
					$this->setItems($ininintag->getParameter("rdf:resource",$ininintag->getParameter("rdf:resource")));
				}
			}
		}		
	}
	function _get($outTag){
		$outTag = parent::_get($outTag);
		$outTag->setParameter("rdf:about",$this->getAbout());

		foreach($this->imageList as $value){
			$tag		= new SimpleTag("image");
			$tag->setParameter("rdf:resource",$value);
			$outTag->addValue($tag->get());
		}
		foreach($this->textinputList as $value){
			$tag		= new SimpleTag("image");
			$tag->setParameter("rdf:resource",$value);
			$outTag->addValue($tag->get());
		}

		$items = "";
		foreach($this->itemsList as $value){
			$tag		= new SimpleTag("rdf:li");
			$tag->setParameter("resource",$value);
			$items .= $tag->get();
		}
		$tag = new SimpleTag("rdf:Seq");
		$tag->setValue($items);
		$items = $tag->get();
		
		$tag = new SimpleTag("items");
		$tag->setValue($items);
		$outTag->addValue($tag->get());

		return $outTag;
	}	
	function setAbout($value){
		$this->about = $value;
	}
	function getAbout(){
		return $this->about;
	}
	function setImage($value){
		$this->imageList = array_merge(Variable::toArray($this->imageList),Variable::toArray($value));
	}
	function getImage(){
		return Variable::toArray($this->imageList);
	}
	function setItems($value){
		$this->itemsList = array_merge(Variable::toArray($this->itemsList),Variable::toArray($value));		
	}
	function getItems(){
		return Variable::toArray($this->itemsList);
	}
	function setTextinput($value){
		$this->textinputList = array_merge(Variable::toArray($this->textinputList),Variable::toArray($value));		
	}
	function getTextinput(){
		return Variable::toArray($this->textinputList);
	}
}