<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/data/OpmlOutline.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.1.0
 */
class Opml{
	var $version = "1.0";
	
	var $title;
	var $dateCreated;
	var $dateModified;
	var $ownerName;
	var $ownerEmail;
	var $expansionState;
	var $vertScrollState;
	var $windowTop;
	var $windowLeft;
	var $windowBottom;
	var $windowRight;

	var $outlineList = array();

	function set($src){
		$tag = new SimpleTag();

		if(!$tag->set($src,"opml")){	
			return false;
		}
		foreach($tag->getIn("title") as $intag){
			$this->setTitle($intag->getValue());
		}
		foreach($tag->getIn("dateCreated") as $intag){
			$this->setDateCreated($intag->getValue());
		}
		foreach($tag->getIn("dateModified") as $intag){
			$this->setDateModified($intag->getValue());
		}
		foreach($tag->getIn("ownerName") as $intag){
			$this->setOwnerName($intag->getValue());
		}
		foreach($tag->getIn("ownerEmail") as $intag){
			$this->setOwnerEmail($intag->getValue());
		}
		foreach($tag->getIn("expansionState") as $intag){
			$this->setExpansionState($intag->getValue());
		}
		foreach($tag->getIn("vertScrollState") as $intag){
			$this->setVertScrollState($intag->getValue());
		}
		foreach($tag->getIn("windowTop") as $intag){
			$this->setWindowTop($intag->getValue());
		}
		foreach($tag->getIn("windowLeft") as $intag){
			$this->setWindowLeft($intag->getValue());
		}
		foreach($tag->getIn("windowBottom") as $intag){
			$this->setWindowBottom($intag->getValue());
		}
		foreach($tag->getIn("windowRight") as $intag){
			$this->setWindowRight($intag->getValue());
		}
		foreach($tag->getIn("outline") as $intag){
			$this->setOutline($intag->get());
		}
		return true;
	}
	function get(){
		$outTag	= new SimpleTag("opml");
		$outTag->setParameter("version",$this->getVersion());

		$headTag	= new SimpleTag("head");
		$tag		= new SimpleTag("dateCreated",$this->getDateCreated());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("dateModified",$this->getDateModified());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("ownerName",$this->getOwnerName());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("ownerEmail",$this->getOwnerEmail());
		$headTag->addValue($tag->get());	
		$tag		= new SimpleTag("expansionState",$this->getExpansionState());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("vertScrollState",$this->getVertScrollState());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("windowTop",$this->getWindowTop());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("windowLeft",$this->getWindowLeft());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("windowBottom",$this->getWindowBottom());
		$headTag->addValue($tag->get());
		$tag		= new SimpleTag("windowRight",$this->getWindowRight());
		$headTag->addValue($tag->get());				

		$outTag->addValue($headTag->get());

		$bodyTag	= new SimpleTag("body");
		foreach($this->getOutline() as $outline){
			if(Variable::isClassType(OpmlOutline,$outline)){
				$bodyTag->addValue($outline->get());
			}
		}
		$outTag->addValue($bodyTag->get());
		
		return $outTag->get();
	}
	function output(){
		$src = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$src .= $this->get();
		
		return StringUtil::encoding($src,StringUtil::getEncodeTypeUTF8());
	}
		
	function setVersion($value){
		$this->version = $value;
	}
	function getVersion(){
		return $this->version;
	}	
	function setTitle($value){
		$this->title = $value;
	}
	function getTitle(){
		return $this->title;
	}
	function setDateCreated($value){
		$this->dateCreated = $value;
	}
	function getDateCreated(){
		return $this->dateCreated;
	}
	function setDateModified($value){
		$this->dateModified = $value;
	}
	function getDateModified(){
		return $this->dateModified;
	}
	function setOwnerName($value){
		$this->ownerName = $value;
	}
	function getOwnerName(){
		return $this->ownerName;
	}
	function setOwnerEmail($value){
		$this->ownerEmail = $value;
	}
	function getOwnerEmail(){
		return $this->ownerEmail;
	}
	function setExpansionState($value){
		$this->expansionState = $value;
	}
	function getExpansionState(){
		return $this->expansionState;
	}
	function setVertScrollState($value){
		$this->vertScrollState = $value;
	}
	function getVertScrollState(){
		return $this->vertScrollState;
	}
	function setWindowTop($value){
		$this->windowTop = $value;
	}
	function getWindowTop(){
		return $this->windowTop;
	}
	function setWindowLeft($value){
		$this->windowLeft = $value;
	}
	function getWindowLeft(){
		return $this->windowLeft;
	}
	function setWindowBottom($value){
		$this->windowBottom = $value;
	}
	function getWindowBottom(){
		return $this->windowBottom;
	}
	function setWindowRight($value){
		$this->windowRight = $value;
	}
	function getWindowRight(){
		return $this->windowRight;
	}
	function setOutline($value){
		$this->outlineList	= Variable::toArray($this->outlineList);	
		$value				= Variable::toArray($value);			
		
		foreach($value as $outline){
			if(Variable::isClassType(OpmlOutline,$outline)){
				$this->outlineList[] = $outline;
			}else{
				$opmloutline = new OpmlOutline();
				if($opmloutline->set($outline)){
					$this->outlineList[] = $opmloutline;
				}
			}
		}
	}
	function getOutline(){
		return Variable::toArray($this->outlineList);
	}
	function getHtmlOutlines(){
		$list = array();		

		foreach($this->outlineList as $outline){
			$list = array_merge($list,$outline->getHtmlOutlines());
		}
		return $list;
	}
	function getXmlOutlines(){
		$list = array();		

		foreach($this->outlineList as $outline){
			$list = array_merge($list,$outline->getXmlOutlines());
		}
		return $list;
	}
}
?>