<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Rss20.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Http.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/data/File.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/Cache.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2006- The Rhacophorus Project. All rights reserved.
 * @version 0.2.0
 */
class FeedParser{
	function read($url,$time=null){
		$src = "";

		if(!Rhaco::define("FEED_CACHE",false) || Cache::isExpiry($url,Rhaco::define("FEED_CACHE_TIME",10800))){
			if(preg_match("/[\w]+:\/\/[\w]+/",$url)){
				$src = ($time > 0) ? Http::modified($url,$time) : Http::body($url);
			}else{
				$src = File::read($url);
			}
			if(Rhaco::define("FEED_CACHE")){
				Cache::set($url,$src);
			}
		}else{
			$src	= Cache::get($url);
		}
		return FeedParser::parse(StringUtil::encoding($src));
	}
	function get($url,$time=null){
		$feed = FeedParser::read($url,$time);
		return $feed->get();
	}
	function getItem($url,$time=null){
		$feed = FeedParser::read($url,$time);
		return $feed->getItem();
	}
	function parse($src){
		$toFeed = new Rss20();

		$fromFeed = new Rss20();
		if($fromFeed->set($src)){
			return $fromFeed;
		}
	
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Rss10.php");		
		$fromFeed = new Rss10();
		if($fromFeed->set($src)){
			$channel	= $fromFeed->getChannel();
			$toFeed->setChannel($channel->getTitle(),$channel->getDescription(),$channel->getLink());
			foreach($fromFeed->getItem() as $item){
				$dc		= $item->getDc();
				$toItem	= new RssItem20($item->getTitle(),$item->getDescription(),$item->getLink());				
				$toItem->setPubDate($dc->getDate());
				$toItem->setAuthor($dc->getCreator());
				$toFeed->setItem($toItem);
			}
			return $toFeed;
		}
		
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Rss09.php");
		$fromFeed = new Rss09();
		if($fromFeed->set($src)){
			$channel = $fromFeed->getChannel();
			$this->feed->setChannel($channel->getTitle(),$channel->getDescription(),$channel->getLink());
			foreach($fromFeed->getItem() as $item){
				$toFeed->setItem($item->getTitle(),$item->getDescription(),$item->getLink());
			}
			return $toFeed;
		}

		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Atom10.php");
		$fromFeed = new Atom10();
		if($fromFeed->set($src)){
			$toFeed->setChannel($fromFeed->getTitle(),$fromFeed->getSubTitle(),$fromFeed->getLinkHref());
			foreach($fromFeed->getEntry() as $item){
				$author		= $item->getAuthor();				
				$content	= $item->getContentValue();
				if(empty($content)){
					$content	= $item->getSummaryValue();					
				}
				$toItem	= new RssItem20($item->getTitle(),$content,$item->getLinkHref());
				$date = $item->getPublished();
				$toItem->setPubDate($item->getUpdated());
				$toItem->setAuthor($author->getName());

				$toFeed->setItem($toItem);
			}
			return $toFeed;
		}
		
		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Atom03.php");
		$fromFeed = new Atom03();
		if($fromFeed->set($src)){
			$toFeed->setChannel($fromFeed->getTitle(),$fromFeed->getTitle(),$fromFeed->getLink());
			foreach($fromFeed->getEntry() as $item){
				$author		= $item->getAuthor();				
				$content		= $item->getContentValue();
				if(empty($content)){
					$content	= $item->getSummaryValue();					
				}
				$toItem	= new RssItem20($item->getTitle(),$content,$item->getLinkHref());				
				$toItem->setPubDate($item->getModified());
				$toItem->setAuthor($author->getName());

				$toFeed->setItem($toItem);
			}
			return $toFeed;
		}

		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/Opml.php");
		$fromFeed = new Opml();
		if($fromFeed->set($src)){			
			$toFeed->setChannel($fromFeed->getTitle(),$fromFeed->getTitle());

			foreach($fromFeed->getHtmlOutlines() as $outline){
				$item = new RssItem20($outline->getTitle(),$outline->getDescription(),$outline->getHtmlUrl());
				$item->setComments($outline->getValue());
				$item->setCategory($outline->getTags());
				$toFeed->setItem($item);
			}
			return $toFeed;
		}

		require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/feed/NetscapeBookmark.php");
		$fromFeed = new NetscapeBookmark();
		if($fromFeed->set($src)){
			foreach($fromFeed->getItems() as $item){
				$toItem	= new RssItem20($item->getTitle(),$item->getTags(),$item->getLink());				
				$toItem->setPubDate($item->getCreated());
				$toItem->setComments($item->getDescription());				
				$toItem->setCategory($item->getTags());				
				$toFeed->setItem($toItem);
			}
			return $toFeed;
		}
		return new Rss20();
	}
	function alternateUrl($baseurl,$src=""){
		if(empty($src)){
			$src		= Http::body($baseurl);
		}
		if(preg_match_all("/<link(.+?)>/i",$src,$link)){
			foreach($link[0] as $value){
				if(substr($value,-2) != "/>"){
					$src = str_replace($value,substr($value,0,-1)."/>",$src);
				}
			}
		}
		$tag = new SimpleTag();
		$tag->set($src);

		foreach($tag->getIn("link") as $link){
			if("alternate" == strtolower($link->getParameter("rel"))){
				return Url::parseAbsolute($baseurl,$link->getParameter("href"));
			}
		}
		return "";
	}
}
?>