<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."resources/Message.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/http/Request.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."network/Url.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/data/SimpleTag.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."tag/HtmlParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."io/FileUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/StringUtil.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/DatabaseColumnParser.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/ProjectModel.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."setup/data/InputValue.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/NotFoundException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/DuplicateException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/DbConnection.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/ExtDbUtil.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.2.7
 */
class SetupGenerator{
	var $error;
	var $fileUtil;
	var $templateParser;

	function SetupGenerator($rhacopath){
		Rhaco::define("NOT_MAKE_CACHE",true);
		Rhaco::define("CONTEXT_PATH",FileUtil::getFilePath(getcwd()));
		Rhaco::define("LIBRARY_PATH",Rhaco::path("library/"));
		Message::loadRhacoMessages();

		$this->templateParser	= new HtmlParser();
		$this->fileUtil		= new FileUtil();
		$this->_view($rhacopath);
				
	}	
	function _getProjectFile(){
		$filename = FileUtil::getFilePath(Rhaco::path(),"setup/project.xml");

		if(!FileUtil::exist($filename)){
			$tag = new SimpleTag("project");
			$tag->setParameter("rhacovar",Rhaco::version());
			$tag->setValue("\n");
			$this->fileUtil->write($filename,$tag->get());
		}
		return File::read($filename);
	}
	function _view($rhacopath){
		$templateParser		= new HtmlParser();
		$request				= new Request();
		$readProjectModel	= $this->_read();

		if($readProjectModel->rhacovar > Rhaco::version()){
			$this->error = Message::_("{1} or above version is required.",$readProjectModel->rhacovar);
		}else{
			if($request->isPost() && $request->isVariable("generate")){
				$projectModel	= $request->toObject(new ProjectModel());
				$databaseList	= $request->getVariable("databaseList");

				foreach(Variable::toArray($databaseList) as $key => $value){
					$database						= $request->getVariable("databaseList");
					$projectModel->databaseList[$key] = Variable::hashConvObject($databaseList[$key],new DatabaseModel());
				}
				foreach(Variable::toArray($request->getVariable("inputList")) as $key => $value){
					$projectModel->defineList[]		= Variable::hashConvObject($value,new InputValue($key));
				}
				foreach(Variable::toArray($request->getVariable("selectList")) as $key => $value){
					$projectModel->defineList[]		= Variable::hashConvObject($value,new InputValue($key));
				}
				foreach(Variable::toArray($request->getVariable("applicationList")) as $key => $value){	
					$projectModel->applicationList[]	= new InputValue($key,$value);
				}
				$projectModel->sessionExpire	= $readProjectModel->sessionExpire;
				$projectModel->sessionCache	= $readProjectModel->sessionCache;	
				$projectModel->cookieExpire	= $readProjectModel->cookieExpire;

				$this->_generate($projectModel);
				
				$templateParser->setVariable($request->getVariable());
				$templateParser->write(Rhaco::rhacoresource("templates/setup/done.html"));
			}else{
				$request->parseObject($readProjectModel);
				$request->setVariable("rhacopath",$rhacopath);
				$templateParser->setVariable($request->getVariable());
				$templateParser->write(Rhaco::rhacoresource("templates/setup/setup.html"));
			}
		}		
	}
	function _read(){
		$tag					= new SimpleTag();
		$projectModel		= new ProjectModel();
		$databaseColumnParser	= new DatabaseColumnParser();
		
		if($tag->set($this->_getProjectFile(),"project")){
			$projectModel = $this->_readProject($tag);

			foreach($tag->getIn("database") as $inTag){
				$database = $databaseColumnParser->readDatabsse($inTag);
				$projectModel->databaseList[$database->class] = $database;
			}
		}
		return $projectModel;
	}
	function _parse($projectModel){
		$tag					= new SimpleTag();
		$databaseColumnParser	= new DatabaseColumnParser();

		if($tag->set($this->_getProjectFile(),"project")){
			$projectModel = $this->_parseProject($tag,$projectModel);
		}
		foreach($tag->getIn("database") as $inTag){
			$database = $databaseColumnParser->parseDatabsse($inTag,$projectModel->databaseList);
			$projectModel->databaseList[$database->class] = $database;		
		}
		return $projectModel;
	}
	function _parseProject($projecttag,$projectModel){	
		foreach($projecttag->getIn("define") as $inTag){
			$projectModel->defineList[] = new InputValue($inTag->getParameter("name","NAME"),$inTag->getParameter("value",""));
		}
		foreach($projecttag->getIn("mkdir") as $inTag){
			$projectModel->directoryList[$inTag->getParameter("path")] = $inTag->getParameter("permission");
		}
		return $projectModel;
	}
	function _generate($projectModel){
		$projectModel		= $this->_parse($projectModel);		
		$databaseColumnParser	= new DatabaseColumnParser();

		if(!ExceptionTrigger::isException()){
			$request["project"] = $projectModel;

			if($this->_writeProject($request)){
				foreach($projectModel->databaseList as $database){
					$databaserequest				= array();
					$databaserequest["database"]	= $database;
					$this->_writeDatabase($databaserequest);
					
					if(Variable::isClassType(DatabaseModel,$database)){
						$dbConnection = new DbConnection();
						$dbConnection->setHost($database->host);
						$dbConnection->setName($database->name);
						$dbConnection->setPassword($database->password);
						$dbConnection->setPort($database->port);
						$dbConnection->setType($database->type);
						$dbConnection->setUser($database->user);
					}
					$dbUtil	= new ExtDbUtil($dbConnection);
				
					if($dbUtil != null && $dbUtil->connection != false && !ExceptionTrigger::isException()){
						$createsql = $databaseColumnParser->_dbforward($database,$dbUtil);
						
						if(!empty($createsql) && !ExceptionTrigger::isException()){
							if($database->create){
								foreach(split(";",$createsql) as $sql){
									if(trim($sql) != ""){
										$dbUtil->query($sql);
									}
								}
							}
						}
						$dbUtil->close();
					}
				}
				foreach($projectModel->applicationList as $application){				
					if($application->value){
						$this->_writeApplication($application);
					}
				}
			}
			return !ExceptionTrigger::isException();
		}
		return false;
	}
	function _writeProject($request){
		if(!ExceptionTrigger::isException()){
			$this->fileUtil->write(
				Rhaco::path("__settings__.php"),
				$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/settings.php.template"),"",$request))
			);
			foreach($request["project"]->directoryList as $path => $permission){
				$this->fileUtil->mkdir(Url::parseAbsolute(Rhaco::path(),$path),$permission);
			}
			$this->fileUtil->mkdir(Rhaco::path("library/data"));
			$this->fileUtil->mkdir(Rhaco::path("resources/templates"));
			$this->fileUtil->mkdir(Rhaco::path("resources/locale/messages"));
			$this->_writeInitFile();
			
			if(Variable::getBoolean($request["project"]->isScaffold)){
				$this->_writeScaffold();
			}
			return !ExceptionTrigger::isException();
		}
		return false;
	}
	function _writeDatabase($request){
		if(!ExceptionTrigger::isException()){
			if(FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),"data")){
				$this->fileUtil->write(
					FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/DbConnection%s.php",$request["database"]->method)),
					$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/DbConnection.php.template"),"",$request))
				);
				$this->fileUtil->write(
					FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("DbUtil%s.php",$request["database"]->method)),
					$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/DbUtil.php.template"),"",$request))
				);
				if(is_array($request["database"]->tableList)){
					foreach($request["database"]->tableList as $table){
						$tablerequest			= array();
						$tablerequest["table"]	= $table;
						$tablerequest["database"]	= $request["database"];

						if(!empty($table->method)){
							$this->fileUtil->write(
								FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/table/%sTable.php",$table->method)),
								$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/data/table/TableObject.php.template"),"",$tablerequest))
							);
							$this->fileUtil->write(
								FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/table/%sTableVerify.php",$table->method)),
								$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/data/table/TableVerifyObject.php.template"),"",$tablerequest))
							);
							if(!$this->fileUtil->exist(FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/verify/%sVerify.php",$table->method)))){
								$this->fileUtil->write(
									FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/verify/%sVerify.php",$table->method)),
									$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/data/verify/VerifyObject.php.template"),"",$tablerequest))
								);
							}
							if(!$this->fileUtil->exist(FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/%s.php",$table->method)))){
								$this->fileUtil->write(
									FileUtil::getFilePath(Rhaco::define("LIBRARY_PATH"),sprintf("data/%s.php",$table->method)),
									$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/library/data/DataObject.php.template"),"",$tablerequest))
								);
							}
						}
					}
				}
			}
			return !ExceptionTrigger::isException();			
		}
		return false;
	}
	function _writeScaffold(){
		if($this->fileUtil->exist(FileUtil::getFilePath(Rhaco::path(),"index.php"))){
			ExceptionTrigger::raise(new DuplicateException(FileUtil::getFilePath(Rhaco::path(),"index.php")));
		}else{
			$this->fileUtil->write(
				FileUtil::getFilePath(Rhaco::path(),"index.php"),
				$this->_getPhp($this->templateParser->read(Rhaco::rhacoresource("templates/index.php.template"),"",$request))
			);
		}
		if($this->fileUtil->exist(FileUtil::getFilePath(Rhaco::path(),"resources/templates/index.html"))){
			ExceptionTrigger::raise(new DuplicateException(FileUtil::getFilePath(Rhaco::path(),"resources/templates/index.html")));
		}else{
			$this->fileUtil->cp(
				Rhaco::rhacoresource("templates/resources/templates/scaffold/index.html"),
				FileUtil::getFilePath(Rhaco::path(),"resources/templates/")
			);
		}
	}
	function _writeApplication($inputValue){
		if($inputValue->title == "authMemberManager"){
			$this->_writeInitFile("setup");
			$this->fileUtil->cp(
				Rhaco::rhacoresource("setup/member.php"), 
				Rhaco::path("setup")
			);
		}
		if($inputValue->title == "potGeneratorr"){
			$this->_writeInitFile("setup");
			$this->fileUtil->cp(
				Rhaco::rhacoresource("setup/po2php.php"), 
				Rhaco::path("setup")
			);
		}
	}
	
	function _writeInitFile($relativePath=""){
		$definepath		= Url::parseRelative(Rhaco::path($relativePath),Rhaco::path("__settings__.php"));
		$defineString	= sprintf("\tinclude_once(\"%s\");",$definepath);

		if(!$this->fileUtil->exist(FileUtil::getFilePath(Rhaco::path($relativePath),"__init__.php"))){
			$this->fileUtil->write(
				FileUtil::getFilePath(Rhaco::path($relativePath),"__init__.php"),
				$this->_getPhp($defineString)
			);
		}
	}
	function _readProject($tag){
		$project = new ProjectModel();
		$project->rhacovar = $tag->getParameter("rhacovar","0");

		foreach($tag->getIn("session") as $inTag){
			if($inTag->isParameter("expire")){
				$project->sessionExpire = $inTag->getParameter("expire");
			}
			if($inTag->isParameter("cache")){
				$project->sessionCache = $inTag->getParameter("cache");
			}
		}
		foreach($tag->getIn("cookie") as $inTag){
			if($inTag->isParameter("expire")){
				$project->cookieExpire = $inTag->getParameter("expire");
			}
		}
		foreach($tag->getIn("input") as $inTag){
			$inputValue = new InputValue($inTag->getParameter("name","NAME"));

			if(defined($inputValue->name)){
				$inputValue->value = constant($inputValue->name);			
			}else{
				foreach($inTag->getIn("data") as $dataTag){
					$inputValue->value = trim($dataTag->getValue());
					break;
				}
			}
			foreach($inTag->getIn("description") as $dataTag){
				$inputValue->description = Message::_(trim($dataTag->getValue()));
				break;
			}
			foreach($inTag->getIn("title") as $dataTag){
				$inputValue->setTitle(Message::_(trim($dataTag->getValue())));
				break;
			}
			$project->inputList[$inputValue->name] = $inputValue;
		}
		foreach($tag->getIn("select") as $inTag){
			$inputValue	= new InputValue($inTag->getParameter("name","NAME"));
			$selected	= false;

			if(defined($inputValue->name)){
				$selected = true;
				$inputValue->value = constant($inputValue->name);
			}
			foreach($inTag->getIn("description") as $dataTag){
				$inputValue->description = Message::_(trim($dataTag->getValue()));
				break;
			}
			foreach($inTag->getIn("title") as $dataTag){
				$inputValue->setTitle(Message::_(trim($dataTag->getValue())));
				break;
			}
			foreach($inTag->getIn("data") as $dataTag){
				$inputValue->dataList[] = new InputValue(Message::_(trim($dataTag->getValue())),$dataTag->getParameter("value"));
				
				if($selected == false && $dataTag->getAttribute("selected") != ""){
					$inputValue->value = $dataTag->getParameter("value");
				}
			}
			$project->selectList[$inputValue->name] = $inputValue;
		}
		return $project;
	}
	function _getPhp($value){
		return sprintf("<?php\n%s\n?>",$value);
	}
}
?>