<?php
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."lang/Variable.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/CriteriaPattern.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."database/data/Criterion.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/ExceptionTrigger.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/ClassTypeException.php");
require_once((defined("RHACO_DIR")?constant("RHACO_DIR"):"")."exception/data/IllegalArgumentException.php");
/**
 * @author Kazutaka Tokushima
 * @license New BSD License
 * @copyright Copyright 2005- The Rhacophorus Project. All rights reserved.
 * @version 0.8.1
 */
class Criteria{
	var $criteriaList					= array();	
	var $criteriaPatternColumnValueList	= array();
	var $criteriaPatternColumnColumnList	= array();
	var $orderList						= array();
	var $joinList						= array();
	var $distinctList					= array();	
	var $limit		= null;
	var $offset		= null;
	var $lock		= null;
	var $verifyFK	= true;
	var $unionAll	= false;
	
	function Criteria($columnOrValueA=null,$columnOrValueB=null){
		if(!empty($columnOrValueA)){
			if(Variable::isClassType(Column,$columnOrValueA)){
				$this->addEqual($columnOrValueA,$columnOrValueB);
			}else{
				foreach(Variable::toArray($columnOrValueA) as $criteriaPattern){
					$this->_add($criteriaPattern);
				}
			}
		}
	}
	function setVerifyFK($boolean){
		$this->verifyFK = Variable::getBoolean($boolean);
	}
	function setPager($pager){
		if(!Variable::isClassType(Pager,$pager)){			
			$this->setLimit($pager->limit);
			$this->setOffset($pager->offset);
		}		
	}
	function setLimit($value){
		$this->limit = Variable::getInt($value);
	}
	function setOffset($value){
		$this->offset = Variable::getInt($value);
	}
	function setLock($value){
		$this->lock = Variable::getBoolean($value);
	}
	function setUnionAll($boolean=false){
		$this->unionAll = $boolean;
	}
	function addOrder($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
			return false;
		}
		$this->orderList[] = new CriteriaPattern($column,null,1);
		return true;
	}
	function addOrderDesc($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));	
			return false;
		}
		$this->orderList[] = new CriteriaPattern($column,null,2);
		return true;
	}
	function addDistinct($column){
		if(!Variable::isClassType(Column,$column)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));			
			return false;
		}
		$this->distinctList[] = $column;
		return true;		
	}
	function addJoin($columnA,$columnB){
		if(!Variable::isClassType(Column,$columnA) || !Variable::isClassType(Column,$columnB)){
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));
		}else{
			$this->joinList[] = new CriteriaPattern($columnA,$columnB);
		}
	}
	function addCriteria($criteria){
		return $this->_addCriteria($criteria,1);
	}
	function addCriteriaOr($criteria){
		return $this->_addCriteria($criteria,2);
	}
	function _addCriteria($criteria,$pattern=1){
		if(!Variable::isClassType(Criteria,$criteria)){		
			ExceptionTrigger::raise(new ClassTypeException(__FUNCTION__));			
			return false;
		}
		$this->criteriaList[] = new CriteriaPattern($criteria,null,$pattern);

		return true;
	}

	function isLimit(){
		return ($this->limit != null);
	}
	function isOffset(){
		return ($this->offset != null);
	}
	function isLock(){
		return ($this->lock != null);
	}
	function isDistinct(){
		return (sizeof($this->distinctList) > 0);
	}	
	function isUnionAll(){
		return Variable::getBoolean($this->unionAll);
	}
	function clear(){
		$this->criteriaList					= array();	
		$this->criteriaPatternColumnValueList	= array();
		$this->criteriaPatternColumnColumnList	= array();
		$this->orderList						= array();
		$this->joinList						= array();		
		$this->limit							= null;
		$this->offset						= null;
		$this->lock							= null;
		$this->distinctList						= array();
	}
	
	function add($columnOrValueA,$columnOrValueB){
		return $this->addEqual($columnOrValueA,$columnOrValueB);
	}
	function addEqual($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::equal($columnOrValueA,$columnOrValueB));
	}
	function addNotEqual($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::notEqual($columnOrValueA,$columnOrValueB));
	}
	function addGreater($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::greater($columnOrValueA,$columnOrValueB));
	}
	function addGreaterEquals($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::greaterEquals($columnOrValueA,$columnOrValueB));
	}	
	function addLess($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::less($columnOrValueA,$columnOrValueB));
	}
	function addLessEquals($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::lessEquals($columnOrValueA,$columnOrValueB));
	}
	function addLike($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::like($columnOrValueA,$columnOrValueB));
	}
	function addNotLike($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::notLike($columnOrValueA,$columnOrValueB));
	}
	function addLikei($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::likei($columnOrValueA,$columnOrValueB));
	}
	function addNotLikei($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::notLikei($columnOrValueA,$columnOrValueB));
	}
	function addIn($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::in($columnOrValueA,$columnOrValueB));
	}
	function addNotIn($columnOrValueA,$columnOrValueB){
		return $this->_add(Criterion::notIn($columnOrValueA,$columnOrValueB));
	}
	function _add($criteriaPattern){
		if(Variable::isClassType(CriteriaPattern,$criteriaPattern)){
			if($criteriaPattern->isColumn()){
				$this->criteriaPatternColumnColumnList[] = $criteriaPattern;
			}else{
				$this->criteriaPatternColumnValueList[] = $criteriaPattern;
			}
		}
	}
	function __tables(){
		$tables = array();

		foreach($this->criteriaPatternColumnColumnList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;
			$tables[$criteriaPattern->columnOrValueB->table->alias][$criteriaPattern->columnOrValueB->column] = $criteriaPattern->columnOrValueB;
		}
		foreach($this->criteriaPatternColumnValueList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;			
		}
		foreach($this->orderList as $criteriaPattern){
			$tables[$criteriaPattern->columnOrValueA->table->alias][$criteriaPattern->columnOrValueA->column] = $criteriaPattern->columnOrValueA;			
		}
		foreach($this->criteriaList as $criteria){
			$tables = array_merge($tables,$criteria->columnOrValueA->__tables());
		}
		return $tables;
	}
}
?>