<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Rss10");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Rss10Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Rss10();
		$src = Http::body(Rhaco::url("feed.php?mode=rss10"));

		$feed->set($src);

		$this->_assert($feed);
	}
	function testGet(){
		$feed = new Rss10();
		$src = Http::body(Rhaco::url("feed.php?mode=rss10"));

		$feed->set($src);
		$fileUtil = new FileUtil();
//		$fileUtil->write(Rhaco::templatepath("tag/feed/rss10Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/rss10Result.xml")),$feed->get());

		$newfeed = new Rss10();
		$newfeed->set($feed->get());
		$this->_assert($newfeed);
	}
/*
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/"><channel rdf:about="http://www.venten.net/index.rdf"><title>venten</title><link>http://www.venten.net/</link><description>目がー！目がー！</description><items><rdf:Seq><rdf:li resource="http://www.venten.net/?eid=409192" /></rdf:Seq></items></channel><item rdf:about="http://www.venten.net/?eid=409192"><dc:subject>技術</dc:subject><dc:creator>kenzii</dc:creator><dc:date>2006-03-31T21:55:35+09:00</dc:date><title>emerge？</title><link>http://www.venten.net/?eid=409192</link><description>今日もサクサク進まないGentooのインストール。
emergeかemerge-webrsyncに原因があると予想して色々調べてるんだけど・・・make.confが間違ってんのかな。
こいつはもう駄目かもわからんね</description></item></rdf:RDF>

<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/"><channel rdf:about="http://www.venten.net/index.rdf"><title>venten</title><link>http://www.venten.net/</link><description>目がー！目がー！</description><items>                                                                 <rdf:Seq /></items></channel><item rdf:about="http://www.venten.net/?eid=409192"><dc:subject>技術</dc:subject><dc:creator>kenzii</dc:creator><dc:date>2006-03-31T21:55:35+09:00</dc:date><title>emerge？</title><link>http://www.venten.net/?eid=409192</link><description>今日もサクサク進まないGentooのインストール。
emergeかemerge-webrsyncに原因があると予想して色々調べてるんだけど・・・make.confが間違ってんのかな。
こいつはもう駄目かもわからんね</description></item></rdf:RDF>

<rdf:Seq />
*/	
	function _assert($feed){
		$this->assertTrue(Variable::isClassType(RssChannel10,$feed->getChannel()));		
		
		$this->assertEquals(1,sizeof($feed->getItem()));
		foreach($feed->getItem() as $item){
			$this->assertTrue(Variable::isClassType(RssItem,$item));
			$this->assertTrue(strlen($item->getTitle()) > 0);
			$this->assertTrue(strlen($item->getLink()) > 0);
			$this->assertTrue(strlen($item->getDescription()) > 0);
			
			$dc = $item->getDc();
			$this->assertEquals("技術",$dc->getSubject());
			$this->assertEquals("2006-03-31T21:55:35+09:00",$dc->getDate());
			$this->assertEquals("kenzii",$dc->getCreator());
		}
	}
}
?>