<?php
Rhaco::import("util.UnitTest");
Rhaco::import("lang.StringUtil");

class StringUtilTest extends UnitTest{
	function setUp(){
		if(!extension_loaded("mbstring")){
			return;
		}
	}
    function tearDown(){
	}
	function testConvertKana(){
		$this->assertEquals("123abcアイウエオ",StringUtil::convertKana("123abcｱｲｳｴｵ"));
	}
	function testConvertZenhan(){
		$this->assertEquals("123123abcabcｱｲｳｴｵ",StringUtil::convertZenhan("123１２３abcａｂｃｱｲｳｴｵ"));
	}
	function testConvertHanzen(){
		$this->assertEquals("１２３１２３ａｂｃａｂｃアイウエオ",StringUtil::convertHanzen("123１２３abcａｂｃｱｲｳｴｵ"));
	}
	function testReplace(){
		$this->assertEquals("123１２３xyzxyzｱｲｳｴｵ",StringUtil::replace("123１２３abcａｂｃｱｲｳｴｵ","abcａｂｃ","xyzxyz"));
		$this->assertEquals("123１２３abcａｂｃｱｲｳｴｵ",StringUtil::replace("123１２３abcａｂｃｱｲｳｴｵ","abcabc","xyzxyz"));		
	}
	function testStrlen(){
		$this->assertEquals(17,StringUtil::strlen("123１２３abcａｂｃｱｲｳｴｵ"));
	}
	function testSubstring(){
		$this->assertEquals("１２３a",StringUtil::substring("123１２３abcａｂｃｱｲｳｴｵ",3,4));
	}
	function testSprintf(){
		$this->assertEquals("123１２３abcａｂｃｱｲｳｴｵ",StringUtil::sprintf("123１２３%s%sｱｲｳｴｵ","abc","ａｂｃ"));		
	}
}
?>