<?php
Rhaco::import("util.UnitTest");
Rhaco::import("lang.DateUtil");

class DateUtilTest extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testParseString(){
		$this->assertEquals(
				"1976-07-23 09:00:00",
				date("Y-m-d H:i:s",DateUtil::parseString("1976-07-23 05:00:00+05:00"))
			);
		$this->assertEquals(
				"2005-06-21 16:21:00",
				date("Y-m-d H:i:s",DateUtil::parseString("2005-06-21 16:21:00"))
			);
		$this->assertEquals(
				"1976-10-04 09:00:00",
				date("Y-m-d H:i:s",DateUtil::parseString("1976-10-04T00:00:00Z"))
			);
		$this->assertEquals(
				"1976-10-04 09:00:00",
				date("Y-m-d H:i:s",DateUtil::parseString("1976-10-04 00:00:00 UTC"))
			);
		$this->assertEquals(
				"2005-08-15 01:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Mon, 15 Aug 2005 01:01:01"))
			);
	}
	function testParseStringAtom(){
		$this->assertEquals(
				"2005-08-15 09:52:01",
				date("Y-m-d H:i:s",DateUtil::parseString("2005-08-15T01:52:01+0100"))
			);		
	}
	function testParseStringCookie(){
		$this->assertEquals(
				"2005-08-15 09:00:00",
				date("Y-m-d H:i:s",DateUtil::parseString("Mon, 15 Aug 2005 00:00:00 UTC"))
			);
	}
	function testParseStringISO8601(){
		$this->assertEquals(
				"2005-08-15 09:52:01",
				date("Y-m-d H:i:s",DateUtil::parseString("2005-08-15T01:52:01+0100"))
			);
	}
	function testParseStringRFC822(){
		$this->assertEquals(
				"2005-08-15 10:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Mon, 15 Aug 2005 01:01:01 UTC"))
			);
	}
	function testParseStringRFC850(){
		$this->assertEquals(
				"2005-08-15 10:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Monday, 15-Aug-05 01:01:01 UTC"))
			);
	}	
	function testParseStringRFC1036(){
		$this->assertEquals(
				"2005-08-15 10:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString(" Monday, 15-Aug-05 01:01:01 UTC"))
			);
	}
	function testParseStringRFC1123(){
		$this->assertEquals(
				"2005-08-15 10:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Mon, 15 Aug 2005 01:01:01 UTC"))
			);
	}	
	function testParseStringRFC2822(){
		$this->assertEquals(
				"2006-08-15 09:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Tue, 15 Aug 2006 01:01:01 +0100"))
			);
	}	
	function testParseStringRSS(){
		$this->assertEquals(
				"2005-08-15 10:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("Mon, 15 Aug 2005 01:01:01 UTC"))
			);
	}	
	function testParseStringW3C(){
		$this->assertEquals(
				"2005-08-15 09:01:01",
				date("Y-m-d H:i:s",DateUtil::parseString("2005-08-15T01:01:01+01:00"))
			);
	}
	function testAddHour(){
		$time = time();

		$this->assertEquals(
				date("Y-m-d H:i:s",$time+3600),
				date("Y-m-d H:i:s",DateUtil::addHour($time,1))
			);
		$this->assertEquals(
				date("Y-m-d H:i:s",$time-3600),
				date("Y-m-d H:i:s",DateUtil::addHour($time,-1))
			);
	}
	function testAddDay(){
		$time = time();

		$this->assertEquals(
				date("Y-m-d H:i:s",$time+(3600*24)),
				date("Y-m-d H:i:s",DateUtil::addDay($time,1))
			);
		$this->assertEquals(
				date("Y-m-d H:i:s",$time-(3600*24)),
				date("Y-m-d H:i:s",DateUtil::addDay($time,-1))
			);
	}
}
?>