<?php
Rhaco::import("util.UnitTest");
Rhaco::import("tag.feed.Atom10");
Rhaco::import("network.http.Http");
Rhaco::import("io.FileUtil");

class Atom10Test extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testSet(){
		$feed = new Atom10();
		$src = Http::body(Rhaco::url("feed.php?mode=atom10"));

		$feed->set($src);
		$this->_assert($feed,0);
	}
	function testGet(){
		$feed = new Atom10();
		$src = Http::body(Rhaco::url("feed.php?mode=atom10"));

		$feed->set($src);
		$fileUtil = new FileUtil();
	
//		$fileUtil->write(Rhaco::templatepath("tag/feed/atom10Result.xml"),$feed->get());
		$this->assertEquals($fileUtil->read(Rhaco::templatepath("tag/feed/atom10Result.xml")),$feed->get());

		$newfeed = new Atom10();
		$newfeed->set($feed->get());
		$this->_assert($newfeed,9);
	}
	
	function _assert($feed,$tzd){
		$this->assertEquals("スパムとか",$feed->getTitle());
		$this->assertEquals($this->_getAtomDate("2006-07-16T07:59:29Z",$tzd),$feed->getUpdated());	

		$link = $feed->getLink();
		
		$this->assertTrue(Variable::isClassType(AtomLink,$link[0]));
		$this->assertEquals("alternate",$link[0]->getRel());
		$this->assertEquals("http://www.everes.net/",$link[0]->getHref());

		$this->assertTrue(Variable::isClassType(AtomLink,$link[1]));
		$this->assertEquals("self",$link[1]->getRel());
		$this->assertEquals("http://www.everes.net/blog/atom/",$link[1]->getHref());

		$author = $feed->getAuthor();
		$this->assertTrue(Variable::isClassType(AtomAuthor,$author));
		$this->assertEquals("makoto",$author->getName());

		$this->assertEquals(1,sizeof($feed->getEntryList()));				

		foreach($feed->getEntryList() as $entry){
			$this->assertTrue(Variable::isClassType(AtomEntry10,$entry));

			$this->assertEquals("Rails側によるDjangoを含むベンチ",$entry->getTitle());

			$linkList = $entry->getLink();

			$this->assertTrue(is_array($linkList));
			foreach($linkList as $link){
				$this->assertTrue(Variable::isClassType(AtomLink,$link));
				$this->assertEquals("alternate",$link->getRel());
				$this->assertEquals("http://www.everes.net/2006/jul/16/django-is-faster-than-rails/",$link->getHref());
			}
			$this->assertEquals("http://www.everes.net/2006/jul/16/django-is-faster-than-rails/",$entry->getId());

			$this->assertEquals($this->_getAtomDate("2006-07-16T07:59:29Z",$tzd),$entry->getUpdated());
			$this->assertEquals($this->_getAtomDate("2006-07-03T15:08:38Z",$tzd),$entry->getPublished());			

			$this->assertTrue($entry->getSummary() != "");			
			$this->assertTrue($entry->getContent() != "");
		}
	}
	function _getAtomDate($dateString,$tzd){
		return DateUtil::formatAtom(DateUtil::addHour(DateUtil::parseString($dateString),$tzd));		
	}
}
?>