<?php
Rhaco::import("util.UnitTest");
Rhaco::import("network.http.Request");
Rhaco::import("network.http.Http");
Rhaco::importLibrary("ClassDummy");

class RequestTest extends UnitTest{
	var $request;
	
	function setUp(){
		$this->request = new Request();
	}
    function tearDown(){
		unset($_SESSION);
	}
	function testSetSession(){
		$this->request->setSession("test","hogehoge");
		$this->assertEquals("hogehoge",$this->request->session["test"]);
		$this->assertEquals("hogehoge",$_SESSION["test"]);
	}
	function testGetSession(){
		$this->request->setSession("test","hogehoge");
		$this->assertEquals("hogehoge",$this->request->getSession("test"));
		$this->assertEquals("hogehogehoge",$this->request->getSession("testtest","hogehogehoge"));
	}
	function testIsSession(){
		$this->request->setSession("test","hogehoge");
		$this->assertTrue($this->request->isSession("test"));
		$this->assertFalse($this->request->isSession("testtest"));
	}
	function testClearSession(){
		$this->request->setSession("test","hogehoge");
		$this->assertTrue($this->request->isSession("test"));
		$this->request->clearSession("test");
		$this->assertFalse($this->request->isSession("test"));		
		$this->assertFalse(isset($_SESSION["test"]));				
	}
	function testSetVariable(){
		$this->request->setVariable("test","hogehoge");
		$this->assertEquals("hogehoge",$this->request->variables["test"]);
	}
	function testGetVariable(){
		$this->request->setVariable("test","hogehoge");
		$this->assertEquals("hogehoge",$this->request->getVariable("test"));
		$this->assertEquals("hogehogehoge",$this->request->getVariable("testtest","hogehogehoge"));
	}
	function testIsVariable(){
		$this->request->setVariable("test","hogehoge");
		$this->assertTrue($this->request->isVariable("test"));
		$this->assertFalse($this->request->isVariable("testtest"));		
	}
	function testMergeVariables(){
		$this->request->setVariable("test","hogehoge");
		$size = sizeof($this->request->variables);
		$list = array("abc"=>123,"def"=>456);
		$this->request->mergeVariables($list);
		$this->assertEquals($size+2,sizeof($this->request->variables));
	}
	function testClearVariable(){
		$this->request->setVariable("test","hogehoge");
		$this->assertEquals("hogehoge",$this->request->variables["test"]);
		$this->request->clearVariable("test");	
		$this->assertFalse($this->request->isVariable("test"));		
	}
	function testGetVariables(){
		$this->request->setVariable("test","hogehoge");
		$size = sizeof($this->request->variables);
		$this->assertEquals($size,sizeof($this->request->getVariables()));				
	}
	function testClearVariables(){
		$this->request->setVariable("test","hogehoge");
		$this->request->clearVariables();
		$this->assertEquals(0,sizeof($this->request->variables));				
	}
	function testToObject(){
		$this->request->setVariable("abc","A");
		$this->request->setVariable("def","B");		
		$this->request->setVariable("hij","C");				
				
		$newobj = $this->request->toObject(new ClassDummy());
		
		$this->assertEquals("A",$newobj->abc);
		$this->assertEquals("B",$newobj->def);
		$this->assertTrue(empty($newobj->hij));		
	}
	function testParseObject(){
		$obj		= new ClassDummy();
		$obj->abc = "A";
		$obj->def = "B";
		$obj->hij = "C";

		$this->request->parseObject($obj);

		$this->assertEquals("A",$this->request->getVariable("abc"));
		$this->assertEquals("B",$this->request->getVariable("def"));				
		$this->assertEquals("Getter[C]",$this->request->getVariable("hij"));
	}
	function testGetUrlMapList(){
		$src = Http::body(Rhaco::url("action/requestGetUrlMapList.php/123/456/789"));
		$this->assertEquals("123456789",$src);
	}
	function testGetUrlMap(){
		$src = Http::body(Rhaco::url("action/requestGetUrlMap.php/123/456/789"));
		$this->assertEquals("456",$src);
		
		$src = Http::body(Rhaco::url("action/requestGetUrlMapNoMap.php/123/456/789"));
		$this->assertEquals("456",$src);		
	}
}
?>