<?php
Rhaco::import("util.UnitTest");
Rhaco::import("network.Url");
Rhaco::import("io.fileUtil");

class UrlTest extends UnitTest{
	function setUp(){
	}
    function tearDown(){
	}
	function testParseAbsolute(){
		$this->assertEquals(
				"http://www.rhaco.org/doc/ja/index.html",
				Url::parseAbsolute("http://www.rhaco.org/","/doc/ja/index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/doc/ja/index.html",
				Url::parseAbsolute("http://www.rhaco.org/","../doc/ja/index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/doc/ja/index.html",
				Url::parseAbsolute("http://www.rhaco.org/","./doc/ja/index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/doc/ja/index.html",
				Url::parseAbsolute("http://www.rhaco.org/doc/ja/","./index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/doc/index.html",
				Url::parseAbsolute("http://www.rhaco.org/doc/ja/","../index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/index.html",
				Url::parseAbsolute("http://www.rhaco.org/doc/ja/","../../index.html")
			);
		$this->assertEquals(
				"http://www.rhaco.org/index.html",
				Url::parseAbsolute("http://www.rhaco.org/doc/ja/","../././.././index.html")
			);
	}
	function testParseRelative(){
		$this->assertEquals(
				"./overview.html",
				Url::parseRelative("http://www.rhaco.org/doc/ja/","http://www.rhaco.org/doc/ja/overview.html")
			);
			
		$this->assertEquals(
				"../overview.html",
				Url::parseRelative("http://www.rhaco.org/doc/ja/","http://www.rhaco.org/doc/overview.html")
			);
		$this->assertEquals(
				"../../overview.html",
				Url::parseRelative("http://www.rhaco.org/doc/ja/","http://www.rhaco.org/overview.html")
			);
		$this->assertEquals(
				"../en/overview.html",
				Url::parseRelative("http://www.rhaco.org/doc/ja/","http://www.rhaco.org/doc/en/overview.html")
			);
		$this->assertEquals(
				"./doc/ja/overview.html",
				Url::parseRelative("http://www.rhaco.org/","http://www.rhaco.org/doc/ja/overview.html")
			);
		$this->assertEquals(
				"./ja/overview.html",
				Url::parseRelative("http://www.rhaco.org/doc/","http://www.rhaco.org/doc/ja/overview.html")
			);			
		$this->assertEquals(
				"http://www.goesby.com/user.php/rhaco",
				Url::parseRelative("http://www.rhaco.org/doc/ja/","http://www.goesby.com/user.php/rhaco")
			);			
	}
	function testParse(){
		$fileUtil = new FileUtil();
		
		$src = $fileUtil->read(Rhaco::templatepath("network/url.html"));
		$src = Url::parse(
					$fileUtil->read(Rhaco::templatepath("network/url.html")),
					"http://www.rhaco.org/test/url/"
				);

		$this->assertEquals(
				$fileUtil->read(Rhaco::templatepath("network/url_success.html")),
				$src
			);				
	}
}
?>