/*
 * Decompiled with CFR 0.152.
 */
package jp.highwide.resourcechecker.sample.quickfix.resolution;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class SampleResolutionGenerator
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<IgnoreWordResolution> result = new ArrayList<IgnoreWordResolution>();
        String name = marker.getAttribute("name", "");
        if (name.equals("\u7981\u5247\u6587\u5b57")) {
            result.add(new IgnoreWordResolution());
        }
        return result.toArray(new IMarkerResolution[0]);
    }

    class IgnoreWordResolution
    implements IMarkerResolution {
        IgnoreWordResolution() {
        }

        public String getLabel() {
            return "\u6b63\u3057\u3044\u6587\u5b57\u306b\u4fee\u6b63\u3059\u308b";
        }

        public void run(IMarker marker) {
            try {
                Map userData = (Map)marker.getAttribute("userData");
                if (userData == null) {
                    throw new RuntimeException("userData\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u518d\u5ea6\u30ea\u30bd\u30fc\u30b9\u30c1\u30a7\u30c3\u30af\u3092\u5b9f\u884c\u3057\u305f\u5f8c\u3001\u30af\u30a4\u30c3\u30af\u30d5\u30a3\u30c3\u30af\u30b9\u3092\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                String rightWord = (String)userData.get("RightWord");
                IDocument doc = this.getDocument(marker);
                int start = marker.getAttribute("charStart", -1);
                int end = marker.getAttribute("charEnd", -1);
                doc.replace(start, end - start, rightWord);
            }
            catch (Exception e) {
                throw new RuntimeException("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            }
        }

        private IDocument getDocument(IMarker marker) {
            AbstractTextEditor textEditor = this.getAbstractTextEditor(marker);
            return textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }

        private AbstractTextEditor getAbstractTextEditor(IMarker marker) {
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow == null) {
                return null;
            }
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editorPart = null;
            try {
                editorPart = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            }
            catch (PartInitException partInitException) {
                return null;
            }
            if (editorPart == null || !(editorPart instanceof AbstractTextEditor)) {
                return null;
            }
            AbstractTextEditor textEditor = (AbstractTextEditor)editorPart;
            return textEditor;
        }
    }
}

