
--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--

with gl;  use gl;
with ada.finalization;
with unchecked_deallocation;



package pictobj2 is 
-- for double-sided textured rectangular region, eg. chainlink fence

-- maps texture coordinates UV to cover the full extent of both sides;
-- thus the whole *.png file is visible



type pictangle is tagged private;

procedure setrect( rect: pictangle;
xc,yc,zc, xr,yr,zr, r,g,b : float
);


procedure draw( rect: pictangle; vertbuff, uvbuff, elembuff : gluint );
procedure draw( rect: pictangle; vertbuff, rgbbuff, uvbuff, elembuff : gluint );

private

nvert : constant integer := 2*72;
nuv : constant integer := 2*48;
nelm : constant integer := 2*36;

type varray is array(1..nvert) of float;
type vap is access varray;

type tarray is array(1..nuv) of float;
type tap is access tarray;

type earray is array(1..nelm) of glushort;
type eap is access earray;

type pictangle is new ada.finalization.controlled with record
	vert : vap;
	colr : vap;
	txuv : tap;
	elem : eap;
end record;


procedure initialize(rect: in out pictangle);
procedure finalize(rect: in out pictangle);

end pictobj2;

