
FSF link:
https://sourceforge.net/projects/reliquarium/files/16sep2022/

# Reliquarium with OpenAL sound


## Recent Changes


**ver 1.9.5 -- 10nov2022**

* Estimated difficulty of T5 is now Medium.
* Improved documentation & coding.


**ver 1.9.4 -- 26sep2022**

* Now using simpler-to-setup GNU Ada for Win64.
* Removed w32 build.
* Added command to raise select-Window after exitting puzzle.


**ver 1.9.3 -- 16sep2022**

* Removed Win64 build.
* Now using GNU Ada rather than defunct AdaCore compiler, even on OSX.
* Removed use of Xcode compiler on OSX.


**ver 1.9.2 -- 16apr2022**

* Reverted linux libraries to exclusively shared format for portability.
* Alternate script for GNU-Ada also works, now.


### See older revision history at end of file



## Reliquarium Game Description
Reliquarium is a very unique set of four 3D slider puzzles, all with a Crystal Skull theme.  Works on Macs running OSX and PCs running Windows or GNU/Linux.

-----------------------------------------------------------
Featuring

	* no installation
	* no dependencies
	* simply unzip in your Downloads directory, and run;
	* or unzip onto a USB flash drive [w/same file format] and run.
-----------------------------------------------------------

=========================================================

## Introduction
A reckless raider from Indiana has been plundering tombs and displacing ancient relics.  The objective is to carefully return each relic to its rightful place at the center of its cubical box by rearranging the numbered blocks back into their proper order.  Colors and numerals help determine the proper order.

Dragging the cursor with the LEFT mouse button rotates the cube for a better view angle.  The keys n/a (Nearer/Away) or the mouse wheel zooms.  Typing a number selects a block to move.  Then use the keys {u,d,l,r,f,b} to move the selected block (Up,Down,Left,Right,Forward,Backward).

Alternatively, you can select a block by RIGHT-clicking the cursor on it, prior to the move.

To make the puzzles much more challenging, you can toggle the numerals with the n-key. Of course that means you will need to use the right mouse button to select the piece you want to move.

As indicated on screen, (h) will toggle a help screen.

These puzzles are easy enough for children but will likely help anyone improve their 3D visualization, geometry, problem solving and computer skills.

There are 4 variations numbered 2, 4, 5, and 6.  Puzzles # 4, 5, & 6 are my own creations, where the numeral represents the vertical size;  while #2 is a well-known [2D] Grabarchuk puzzle.  Generally, the puzzles with a smaller number are somewhat more difficult.  Puzzle #4 is the most compact & difficult.


## General Strategy
Temporarily combine complementary pieces to maximize contiguous empty swap space.


## Game Features
* Works on PCs or laptops running Windows, OSX or GNU/Linux.  And if Ada is installed you can build it yourself!  But first try the delivered, prebuilt binaries.

* Windows, GNU/Linux and OSX binaries provided, as well as full source.

* Laptop friendly controls;  supports Mac Retina displays.



## Mouse/touchpad/keyboard controls

Look direction is controlled by a touch pad swipe or mouse drag;

Movement is controlled by the keys:  
	u d l r f b  (Up Down Left Right Forward Backward)

In other words...

*	forward/backward : moves selected block in Z direction
*	right/left       : moves selected block in X-direction
*	up/down          : moves selected block in Y-direction

This terminology for key-assignments assumes X+ is rightward, Y+ is upward, and Z+ is outward...the standard "view" for geometrical discussions in mathematics and physics.  Note that the X, Y, & Z Axes are displayed by default.

Obviously this might get confusing if you rotate the figure to get a better look. That is part of the challenge!

Keys active:

* (esc)-key => Exit puzzle
* (q)-key => Exit selection screen
* (mouseWheel) => Zoom
* (i)/(o)-keys => Zoom In/Out
* (spc)-key => Restart
* (c)-key => nextSkinColor
* (n)-key => toggle Numerals
* (h)-key => Help toggle
* 0-9 => select numbered block
* (s)-key => select Skull
* (m)-key => select Medusa head
* (v)-key => toggle move-sounds

Main Movement Keys: Arrows, Letters

* (up)-key, (u)-key => +Y
* (dn)-key, (d)-key => -Y
* (lf)-key, (l)-key => -X
* (rt)-key, (r)-key => +X

* (f)-key => +Z
* (b)-key => -Z

------------------------------------------------------------


## Required for running:

* graphics card & updated driver that supports OpenGL version 3.3 or later;
* Windows, GNU/Linux or OSX>=10.13(sep2017);


## Setup and Running Reliquarium:

Windows users should read "windows-setup.txt".
Mac users see "osx-setup.txt".

Unzip the archive.  On Windows, 7z [www.7-zip.org] works well for this.  On OSX, you can use Keka.

Open a command line terminal, then cd to the install directory.

--------------------------------------------------------------------
Windows users type "w64reliq.bat" 

--------------------------------------------------------------------
Linux users type "gnureliq.sh" to start the game.
In Linux, you may also double click the icon for reliquarium in the file manager.

Another option, however is that linux users can probably run the Windows executables under "wine". Here are two examples that work on my linux machine:

		wine bin/win/reliquarium.exe

		wine bin/win/tomb6.exe

Thusly, each executable can be called directly, skipping the selection screen. Without wine that would be:

		bin/gnu/tomb6

On the other hand, I suggest that Windows users DO NOT try running the linux executables under WSL [Windows Subsystem for Linux]; that mode is not supported. Simply use the windows version.


--------------------------------------------------------------------
The Mac command line version is initiated by opening a terminal, navigating to the install_directory, and typing "macreliq.sh" on the command line.

Also, for Mac users, there is a Mac bundle (named "reliquarium.app") that acts like a typical Mac app.  You can put it into your personal Applications directory with the command "cp -r reliquarium.app ~/Applications".  You can navigate to the installation directory in Finder and click the reliquarium.app icon named "Reliquarium".


Select which of the four tombs to open by clicking on it.  Hit the (esc)-key at any time to return to the selector app;  hit (q)-key to quit completely.

Hint: if the move sound goes silent, you probably hit the "v" key by mistake.

--------------------------------------------------------------------------

Feel free to send comments, suggestions or questions to:  <fastrgv@gmail.com>

--------------------------------------------------------------------------

## Open Source libraries included for rebuilding:
* systems:  Windows, OSX or GNU/Linux
* a recent Ada compiler;  eg. GNU-Ada...try this source:
	https://github.com/alire-project/GNAT-FSF-builds/releases

* the ./adabindings/ directory contains Ada interfaces for:
	* AdaPngLib
	* gl
	* glfw
	* FreeType
	* OpenAL (Windows)



## Build instructions:

Three [pre-compiled] binary executables are provided, one for Windows, one for gnu/linux and one for OSX.

Build scripts for GNU Ada [with its own g++] are provided. 

-------------------------------------------------------
msWin64 => setpath64.bat + wbuildAll.bat

Windows users please read gnuAdaOnWindows.txt


-------------------------------------------------------
MacOSX => obuildAll.sh:

build script for generating a portable executable that will run on most OSX platforms whether or not they have non-standard libraries installed.  Any Mac with a recent but standard configuration of OSX should be able to rebuild using this script.  Here, all nonstandard libraries are included under the ./libs/ directory and are statically linked. 

Note: Xcode is not required.


------------------------------------------------------
GNU/Linux => lbuildAll.sh (GNU Ada)

utilizes the uncommon relocatable libraries (mainly GLFW) that are delivered in this bundle under ./libs/.  This is used to build a dynamically linked [gnu/linux] executable, which should run in the presence of ./libs, whether or not your system has those libraries installed.





## What is special about this project?
It uses the Ada programming language and modern OpenGL methods, with textures, shaders and uniforms.  Compiles and runs on Windows, GNU/Linux and Mac OSX systems.

Focusing on portability, transparency, and open source freedom, this project relies exclusively on F.O.S.S. tools:  a thin GLFW3 binding, a thin OpenGL binding, a PNG reader by Stephen Sanguine & Dimitry Anisimkov, OpenAL-Audio with a homebrew binding, and an Ada compiler.

Written in C++ style, the code neglects many safety features available to Ada, but it does serve as a working example for learning OpenGL.  The Ada bindings used are thin, so the relationship to C++ methodology is transparent.  Developers should note that these Ada bindings are usable as a standalone library for most any OpenGL project that uses Ada.

Thus, for the C++ programmer the code should be easy to comprehend; and for the experienced Ada programmer there are many potential improvements to be made.  

Open source Ada developers are welcome to help improve or extend this app.
Developer or not, send comments, suggestions or questions to:
fastrgv@gmail.com


--------------------------
## License:


Reliquarium is covered by the GNU GPL v3 as indicated in the sources:


 Copyright (C) 2022  <fastrgv@gmail.com>

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You may read the full text of the GNU General Public License
 at <http://www.gnu.org/licenses/>.


## Media Files for Reliquarium:

It is my intention to use media with copyrights or licenses that are compatible with GPLv3. Please notify me if you believe there is an incompatibility, and it will be removed ASAP, eg a CC-by-NC license is NOT GPL compatible.



### SoundFiles [x.wav]
Some sounds are from freesound.org and are covered by the Creative Commons CC0 license documented in the accompanying file ./docs/creativeCommonsCC0.txt.  Others [eg. shriek] are from http://www.freesfx.co.uk, which have an attribution requirement, but no legal restrictions otherwise. See ./docs/freeSFXlicense.txt.

### ImageFiles 
Images for textures were from pixabay.com have a CC0 license.  Files for text-textures were created using gimp and are also covered by the GNU GPL v3 license.

## Thanks:
... to Serhiy and Peter Grabarchuk for their Hole in One puzzle [tomb2], one of my inspirations for the other 3 puzzles in Reliquarium.

----------------------------------------------------------------
## Download Site for all my games:
https://github.com/fastrgv?tab=repositories
https://www.indiedb.com/members/fastrgv/games
https://fastrgv.itch.io
https://sourceforge.net/u/fastrgv/profile/
https://gamejolt.com/@fastrgv/games


## Revision History:


**ver 1.9.1 -- 19jan2022**

* Updated Windows builds to freetype v2.11.1 DLLs (w32,w64).
* Updated linux libs to use static libfreetype.a & libpng16.a
* Updated libglfw.
* Ensured all media now have licenses compatible with GPLv3.


**ver 1.9.0 -- 15nov2021**

* Updated glext64.lib.
* Cleaned up libs; prepped rpath for GNAT.
* Improved scripting supports both AdaCore & GNAT EXEs on Linux.
* Updated all GLFW libs to newer [static] version, & scripts.
* Elliminated OpenGL-mipmap error on nvidia nouveau drivers.
* Derestricted the directory of execution.



**ver 1.8.9 -- 21oct2021**

* Updated libraries.
* Increased separation of puzzle pieces.
* Updated tomb2 display to match others.
* Besides Win64, I now provide a Win32 build, to support older platforms.

**ver 1.8.8 -- 10oct2021**

* Enabled normal window exit.
* Added option to toggle numerals off, to increase challenge.
* Added slight offset to separate distinct puzzle pieces.
* Fixed GL error message in Linux.


**ver 1.8.7 -- 20feb21**

* Upgraded to OpenAL sound.


**ver 1.8.6 -- 28oct20**
* Updated all glfw libs to v3.3.2.
* Elliminated SFML-audio entirely.
* Greatly simplified build process.


**ver 1.8.5 -- 18apr20**

* OpenGL v3.3 is now sufficient to run this app...allows older hardware.
* Improved coding style to read WAV file while "protected";
* Added a move-sound mute-toggle using v-key (Volume);


**ver 1.8.4 -- 3apr20**

* Created new linux sound system with no latency:  a WAV-player using an Ada binding to the ALSA sound library.
* Sliding sounds have been reenabled; other sounds equilibrated.


**ver 1.8.3 -- 10mar20**

* Fixed bad sound file. Sliding sounds disabled on Linux due to significant latency.


**ver 1.8.2 -- 18jan20**

* Alternate sound system greatly improves linux portability.


**ver 1.8.1 -- 5jan20**

* Added FreeTypeAda (w/TTF);
* Corrected & improved help screens;


**ver 1.8.0 -- 28dec19**

* Converted to GLFW;
* Improved & simplified code structure & layout;


**ver 1.7.0 -- 20dec19**

* Fixed path problem that disallowed running from "relic" directory.


**ver 1.6.9 -- 26nov19**

* Repaired a library problem with GNU/Linux build that limited portability.
* No problems with Mac/OSX or M.S. Windows builds.


**ver 1.6.8 -- 26jun19**

* Changed axis labels to High Contrast Font;
* Darkened background;
* Executables can now be run from either of 2 directories.

...

**ver 1.0 -- 21jan16**

* initial release

