# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Timer

describe RDGC::Timer::AutoHealingTimer, "will call target's #auto_heal at cycle" do

  before do
    @target = Object.new

    class << @target
      def auto_heal
        @test = "auto_heal!!"
      end

      def test
        @test
      end

      def test_reset
        @test = nil
      end
      
      def disable?
        @disable
      end
      
      def disable
        @disable = true
      end
    end
  end

  it "create timer with cycle term and target" do
    timer = AutoHealingTimer.create(10, @target)
    timer.should be_an_instance_of(AutoHealingTimer)
    timer.cycle_type?.should be_true
    timer.limit_type?.should be_false

    timer.update(5)
    timer.action_ok?.should be_false
    timer.action.should be_false
    @target.test.should be_nil

    timer.update(5)
    timer.action_ok?.should be_true
    timer.action.should == :auto_heal
    @target.test.should == "auto_heal!!"
    @target.test_reset
    @target.test.should be_nil

    timer.update_ratio = 2.0
    timer.update(5)
    timer.action_ok?.should be_true
    timer.action.should == :auto_heal
    @target.test.should == "auto_heal!!"
  end

  it "not create timer if illegal params" do
    timer1 = AutoHealingTimer.create(0, @target)
    timer1.should be_nil

    timer2 = AutoHealingTimer.create(100, nil)
    timer2.should be_nil
  end
  
  it "#disable? check target's status" do
    timer = AutoHealingTimer.create(10, @target)
    timer.should be_an_instance_of(AutoHealingTimer)
    @target.disable?.should be_false
    timer.disable?.should be_false
    
    @target.disable
    @target.disable?.should be_true
    timer.disable?.should be_true
  end

end
