# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Timer

describe RDGC::Timer::Base, "has time, and work on cycle or limit" do

  before do
    @timer = Object.new
    @timer.extend(Timer::Base)
  end

  it "cycle/limit/update_ratio is params of timer" do
    @timer.cycle.should be_nil
    @timer.limit.should be_nil
    @timer.update_ratio.should == 1.0

    @timer.cycle = -1
    @timer.cycle.should be_nil
    @timer.limit = -1
    @timer.limit.should be_nil
    @timer.update_ratio = 0
    @timer.update_ratio.should == 1.0

    @timer.cycle = 10
    @timer.cycle.should == 10
    @timer.limit = 100
    @timer.limit.should == 100
    @timer.update_ratio = 1.1
    @timer.update_ratio.should == 1.1
  end

  it "#cycle_type?/#limit_type judge each type of timer" do
    @timer.cycle.should be_nil
    @timer.cycle_type?.should be_false

    @timer.cycle = 10
    @timer.cycle_type?.should be_true

    @timer.limit.should be_nil
    @timer.limit_type?.should be_false

    @timer.limit = 100
    @timer.limit_type?.should be_true
  end

  it "#update will countup timer (for cycle only)" do
    @timer.cycle = 10
    @timer.cycle_type?.should be_true
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 0.0

    @timer.update
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 1.0

    @timer.update(5)
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 6.0

    @timer.update_ratio = 0.5
    @timer.update(10)
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 11.0
  end

  it "#update will countup timer (for limit only)" do
    @timer.limit = 100
    @timer.limit_type?.should be_true
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 0.0

    @timer.update
    @timer.pass_time.should == 1.0
    @timer.cycle_time.should == 0.0

    @timer.update(5)
    @timer.pass_time.should == 6.0
    @timer.cycle_time.should == 0.0

    @timer.update_ratio = 0.5
    @timer.update(10)
    @timer.pass_time.should == 11.0
    @timer.cycle_time.should == 0.0
  end

  it "#update will countup timer (for both)" do
    @timer.cycle = 10
    @timer.limit = 100
    @timer.cycle_type?.should be_true
    @timer.limit_type?.should be_true
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 0.0

    @timer.update
    @timer.pass_time.should == 1.0
    @timer.cycle_time.should == 1.0

    @timer.update(5)
    @timer.pass_time.should == 6.0
    @timer.cycle_time.should == 6.0

    @timer.update_ratio = 0.5
    @timer.update(10)
    @timer.pass_time.should == 11.0
    @timer.cycle_time.should == 11.0
  end

  it "#reset_cycle/#reset will reset timer count" do
    @timer.cycle = 10
    @timer.limit = 100

    @timer.update
    @timer.pass_time.should == 1.0
    @timer.cycle_time.should == 1.0

    @timer.reset_cycle
    @timer.pass_time.should == 1.0
    @timer.cycle_time.should == 0.0

    @timer.update
    @timer.pass_time.should == 2.0
    @timer.cycle_time.should == 1.0

    @timer.reset
    @timer.pass_time.should == 0.0
    @timer.cycle_time.should == 0.0
  end

  it "#cycle_arrive?/#limit_arrive? will check time arrival" do
    @timer.cycle = 5
    @timer.limit = 10
    @timer.update_ratio = 0.3

    @timer.cycle_type?.should be_true
    @timer.limit_type?.should be_true
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_false

    @timer.update(10)
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_false

    @timer.update(7)
    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_false

    @timer.update(17)
    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_true
  end

  it "#action_ok? will check timer arrival (for cycle only)" do
    @timer.cycle = 5
    @timer.update_ratio = 0.3

    @timer.cycle_type?.should be_true
    @timer.limit_type?.should be_false
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_false
    @timer.action_ok?.should be_false

    @timer.update(17)
    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_false
    @timer.action_ok?.should be_true
  end

  it "#action_ok? will check timer arrival (for limit only)" do
    @timer.limit = 10
    @timer.update_ratio = 0.3

    @timer.cycle_type?.should be_false
    @timer.limit_type?.should be_true
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_false
    @timer.action_ok?.should be_false

    @timer.update(34)
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_true
    @timer.action_ok?.should be_true
  end

  it "#action_ok? will check timer arrival for both, only check cycle arrival" do
    @timer.cycle = 5
    @timer.limit = 10
    @timer.update_ratio = 0.3

    @timer.cycle_type?.should be_true
    @timer.limit_type?.should be_true
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_false
    @timer.action_ok?.should be_false

    @timer.update(17)
    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_false
    @timer.action_ok?.should be_true

    @timer.update(34)
    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_true
    @timer.action_ok?.should be_true

    @timer.reset_cycle
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_true
    @timer.action_ok?.should be_false
  end

  it "#finish? will check limit arrival" do
    @timer.cycle = 5
    @timer.limit = 10
    @timer.update(10)

    @timer.cycle_arrive?.should be_true
    @timer.limit_arrive?.should be_true
    @timer.action_ok?.should be_true
    @timer.finish?.should be_true

    @timer.reset_cycle
    @timer.cycle_arrive?.should be_false
    @timer.limit_arrive?.should be_true
    @timer.action_ok?.should be_false
    @timer.finish?.should be_true
  end

  it "#next_time for cycle only provides next cycle time" do
    @timer.cycle = 5
    @timer.update_ratio = 0.5
    @timer.next_time.should == 5.0

    @timer.update
    @timer.next_time.should == 4.5

    @timer.update(10)
    @timer.next_time.should == -0.5
  end

  it "#next_time for limit only provides time to limit" do
    @timer.limit = 5
    @timer.update_ratio = 0.5
    @timer.next_time.should == 5.0

    @timer.update
    @timer.next_time.should == 4.5

    @timer.update(10)
    @timer.next_time.should == -0.5
  end

  it "#next_time for both provide cycle's next time" do
    @timer.cycle = 5
    @timer.limit = 10
    @timer.update_ratio = 0.5
    @timer.next_time.should == 5.0

    @timer.update(11)
    @timer.next_time.should == -0.5

    @timer.update(10)
    @timer.next_time.should == -5.5
  end

  it "#next_count provides next arrival count with update_ratio" do
    @timer.cycle = 5
    @timer.update_ratio = 0.5
    @timer.next_time.should == 5.0

    @timer.update
    @timer.next_time.should == 4.5
    @timer.next_count.should == 9

    @timer.update(10)
    @timer.next_time.should == -0.5
    @timer.next_count.should == -1
  end

end
