# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/monster_spec_board')

describe RDGC::Monster::ActiveChaseType, "is monster type, chase in active, random in non_active" do

  before(:all) do
    @board = create_board
  end

  before do
    @monster = Character::Base.new
    @monster.extend(Monster::ActiveChaseType)

    class << @monster

      attr_accessor :view_range

    end

    @player = Character::Player.new
    @floor = Map::Floor.create_from_board(@board)

    @floor.add_article(@monster)
    @floor.add_article(@player)
  end

  it "#chase_try_count provides max chance of chase" do
    @monster.chase_try_count.should == 2
    @monster.chase_try_count = 1
    @monster.chase_try_count.should == 1
    @monster.chase_try_count = -1
    @monster.chase_try_count.should == 1
  end

  it "#state express monster's action mode" do
    @monster.state.should == :non_active
    @monster.active?.should be_false
    @monster.non_active?.should be_true

    @monster.to_active
    @monster.state.should == :active
    @monster.active?.should be_true
    @monster.non_active?.should be_false

    @monster.to_non_active
    @monster.state.should == :non_active
    @monster.active?.should be_false
    @monster.non_active?.should be_true
  end

  it "#check_state will choice check type for state change" do

    class << @monster

      # override
      def check_state_for_active
        "check_state_for_active"
      end

      # override
      def check_state_for_non_active
        "check_state_for_non_active"
      end

    end

    @monster.non_active?.should be_true
    @monster.check_state.should == "check_state_for_non_active"

    @monster.to_active
    @monster.active?.should be_true
    @monster.check_state.should == "check_state_for_active"

    @monster.to_non_active
    @monster.non_active?.should be_true
    @monster.check_state.should == "check_state_for_non_active"
  end

  it "#check_state_for_active will check chase_miss_count capacity" do
    @monster.to_active
    @monster.active?.should be_true
    @monster.chase_miss_count.should == 0
    @monster.chase_try_count.should == 2

    @monster.check_state
    @monster.active?.should be_true

    @monster.add_miss_count
    @monster.chase_miss_count.should == 1
    @monster.check_state
    @monster.active?.should be_true

    @monster.add_miss_count
    @monster.chase_miss_count.should == 2
    @monster.check_state
    @monster.active?.should be_false
    @monster.non_active?.should be_true
    @monster.chase_miss_count.should == 0
  end

  it "#check_state_for_non_active will check interesting article in view_range" do
    @monster.to_non_active
    @monster.non_active?.should be_true
    @monster.view_range = 2

    @monster.set(2, 2)
    @player.set(2, 5)
    @monster.check_state
    @monster.non_active?.should be_true

    @player.set(2, 4)
    @monster.check_state
    @monster.non_active?.should be_false
    @monster.active?.should be_true
  end

  it "#monster_action will choice acvite_action or non_active_action, with state" do

    class << @monster

      # override
      def active_action
        "active_action"
      end

      # override
      def non_active_action
        "non_active_action"
      end

    end

    @monster.view_range = 2
    @monster.set(2, 2)
    @player.set(2, 5)

    @monster.non_active?.should be_true
    @monster.monster_action.should == "non_active_action"

    @player.set(2, 4)
    @monster.monster_action.should == "active_action"

    @player.set(7, 7)
    2.times{@monster.add_miss_count}
    @monster.monster_action.should == "non_active_action"
  end

end
