# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Map

describe RDGC::Map::Floor do

  before(:all) do
    @block1 = Block.create(0, 19, 0, 9)
    @block2 = Block.create(0, 19, 10, 19)

    @room1 = Room.create(2, 7, 2, 7)
    @room2 = Room.create(10, 15, 12, 16)

    @road1 = Road.create(5, 5, 8, 9)
    @road2 = Road.create(5, 13, 9, 9)
    @road3 = Road.create(13, 13, 10, 11)

    @block1.room = @room1
    @block2.room = @room2
    @block1.add_road(@road1)
    @block1.add_road(@road2)
    @block2.add_road(@road3)

    @board = Board.create_from_blocks([@block1, @block2])
  end

  it "has board and some methods delegate to board it has" do
    floor = Floor.new
    floor.board.should be_nil
    floor.blocks.should be_empty
    floor.rooms.should be_empty
    floor.roads.should be_empty
    floor.areas.should be_empty
    floor.areas_for(5, 5).should be_empty
    floor.movable?(5, 5).should be_false
    floor.room?(5, 5).should be_false
    floor.road?(5, 9).should be_false

    floor.set_board(@board)
    floor.board.should == @board

    [@block1, @block2].each do |b|
      floor.blocks.should be_include(b)
    end

    [@room1, @room2].each do |r|
      floor.rooms.should be_include(r)
    end

    [@road1, @road2, @road3].each do |r|
      floor.roads.should be_include(r)
    end

    [@room1, @room2, @road1, @road2, @road3].each do |r|
      floor.areas.should be_include(r)
    end

    floor.areas_for(5, 5).should == [@room1]
    floor.movable?(5, 5).should be_true
    floor.room?(5, 5).should be_true
    floor.road?(9, 5).should be_true
  end

  it "create_from_board will create new floor with board" do
    floor = Floor.create_from_board(@board)
    floor.board.should == @board
  end

end
