# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require 'rdgc/device/device_dummy'

include RDGC::Device

describe RDGC::Device::In, "is Input interfce of dummy" do

  it "push_key will set dummy key, reset_key will remove push info" do
    In.up?.should be_false
    In.push_key(:up)
    In.up?.should be_true
    In.reset_key
    In.up?.should be_false

    In.down?.should be_false
    In.push_key(:down)
    In.down?.should be_true
    In.reset_key
    In.down?.should be_false

    In.left?.should be_false
    In.push_key(:left)
    In.left?.should be_true
    In.reset_key
    In.left?.should be_false

    In.right?.should be_false
    In.push_key(:right)
    In.right?.should be_true
    In.reset_key
    In.right?.should be_false

    In.accept_button?.should be_false
    In.push_key(:accept_button)
    In.accept_button?.should be_true
    In.reset_key
    In.accept_button?.should be_false

    In.escape_key?.should be_false
    In.push_key(:escape_key)
    In.escape_key?.should be_true
    In.reset_key
    In.escape_key?.should be_false
  end

  it "push_dir_key? will check direction key is pushed" do
    In.push_dir_key?.should be_false
    In.push_key(:up)
    In.push_dir_key?.should be_true
    In.push_key(:down)
    In.push_dir_key?.should be_true
    In.push_key(:left)
    In.push_dir_key?.should be_true
    In.push_key(:right)
    In.push_dir_key?.should be_true
    In.push_key(:accept_button)
    In.push_dir_key?.should be_false
    In.push_key(:escape_key)
    In.push_dir_key?.should be_false
    In.reset_key
    In.push_dir_key?.should be_false
  end

end

