# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/swordman')

describe RDGC::Character::BattleRoll, "is judge rule of battle" do

  before do
    @player = RDGC::Character::Player.create(RDGC::Character::Swordman)
  end

  it "each battle params" do
    @player.should be_kind_of(RDGC::Character::BattleRoll)

    9.times{@player.lvup}
    @player.lv.should == 10

    @player.critical.should == 21
    @player.fumble.should == 6
    @player.critical_ratio.should == 2.0

    @player.str.should == 10
    @player.wep_atk.should == 0
    @player.atk.should == 10
    @player.set_wep_atk(5)
    @player.atk.should == 15

    @player.vit.should == 8
    @player.arm_def.should == 0
    @player.pdef.should == 8
    @player.set_arm_def(10)
    @player.pdef.should == 18

    @player.hit_revise.should == 14
    @player.dex.should == 7
    @player.hit.should == 12
    @player.agi.should == 5
    @player.flee.should == 7
  end

  it "#roll_dice provides roll dice result" do
    100.times do
      d = @player.roll_dice
      d.should >= 4
      d.should <= 24
    end
  end

  it "#damage_point provides damage point of attaker by roll dice" do
    5.times{@player.lvup}
    @player.str.should == 8
    @player.atk.should == 8

    1000.times do
      d = @player.damage_point
      d.should >= 6
      d.should <= 16
    end

    @player.set_wep_atk(2)
    @player.atk.should == 10

    1000.times do
      d = @player.damage_point
      d.should >= 8
      d.should <= 18
    end

    @player.set_wep_atk(3)
    @player.atk.should == 11

    1000.times do
      d = @player.damage_point
      d.should >= 11
      d.should <= 31
    end
  end

  it "#reduce_point provides reduce point of defender by roll dice" do
    4.times{@player.lvup}
    @player.vit.should == 6
    @player.pdef.should == 6

    1000.times do
      d = @player.reduce_point
      d.should >= 4
      d.should <= 14
    end

    @player.set_arm_def(4)
    @player.pdef.should == 10

    1000.times do
      d = @player.reduce_point
      d.should >= 8
      d.should <= 18
    end

    15.times{@player.lvup}
    @player.vit.should == 12
    @player.set_arm_def(1)
    @player.pdef.should == 13

    1000.times do
      d = @player.reduce_point
      d.should >= 8
      d.should <= 28
    end
  end

  it "#attack_roll will decide attack result with roll dice" do
    target = RDGC::Character::Player.create(RDGC::Character::Swordman)
    29.times{@player.lvup}
    49.times{target.lvup}
    @player.set_wep_atk(10)

    1000.times do
      rsl, val = @player.attack_roll(target)
      [:hit, :critical, :miss, :fumble].include?(rsl).should be_true

      case rsl
      when :hit
        val.should > 0
        val.should >= (@player.dex/5.0).ceil
      when :critical
        val.should > 0
        val.should >= @player.dex
      when :miss, :fumble
        val.should == 0
      end
    end
  end

end
