# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/swordman')
require 'rdgc/device/device_dummy'

describe RDGC::Character::Player, "is character of Player controlled" do

  before(:all) do
    @board = Maker::DivideDungeonMaker.create(20, 20, :min_room_size => 99)
  end

  before do
    @player = RDGC::Character::Player.create(RDGC::Character::Swordman)

    @floor = Map::Floor.create_from_board(@board)
    @floor.add_article(@player)

    @step_up = Article::Step.create_up_step(5, 5)
    @floor.add_article(@step_up)
    @step_down = Article::Step.create_down_step(15, 15)
    @floor.add_article(@step_down)

    @device = RDGC::Device::In
  end

  it "create from job" do
    @player.should be_an_instance_of(RDGC::Character::Player)
    @player.job.should == RDGC::Character::Swordman
    @player.hp.should == @player.max_hp
    @player.sp.should == @player.max_sp
  end

  it "#move_action will move player to inputed direction" do
    @player.set(10, 10)

    @device.push_key(:up)
    @player.move_action.should == :moved
    @player.exist?(10, 9).should be_true

    @device.push_key(:right)
    @player.move_action.should == :moved
    @player.exist?(11, 9).should be_true

    @device.push_key(:down)
    @player.move_action.should == :moved
    @player.exist?(11, 10).should be_true

    @device.push_key(:left)
    @player.move_action.should == :moved
    @player.exist?(10, 10).should be_true
  end

  it "#button_action will action to ground articles" do
    @player.set(5, 6)
    @player.overlap?(@step_up).should be_false

    @device.push_key(:accept_button)
    @player.button_action.should == :stay

    @device.push_key(:up)
    @player.move_action.should == :moved
    @player.exist?(5, 5).should be_true
    @player.overlap?(@step_up).should be_true

    @device.push_key(:accept_button)
    @player.button_action.should == :step_up

    @player.set(14, 15)
    @player.overlap?(@step_down).should be_false

    @device.push_key(:accept_button)
    @player.button_action.should == :stay

    @device.push_key(:right)
    @player.move_action.should == :moved
    @player.exist?(15, 15).should be_true
    @player.overlap?(@step_down).should be_true

    @device.push_key(:accept_button)
    @player.button_action.should == :step_down
  end

  it "#action will action for inputed button" do
    @player.set(5, 6)
    @player.overlap?(@step_up).should be_false

    @device.push_key(:accept_button)
    @player.action.should == :player_stay

    @device.push_key(:up)
    @player.action.should == :player_moved
    @player.exist?(5, 5).should be_true
    @player.overlap?(@step_up).should be_true

    @device.push_key(:accept_button)
    @player.action.should == :player_step_up

    @device.push_key(:right)
    9.times{@player.action.should == :player_moved}
    @device.push_key(:down)
    10.times{@player.action.should == :player_moved}

    @player.exist?(14, 15)
    @player.overlap?(@step_down).should be_false

    @device.push_key(:accept_button)
    @player.action.should == :player_stay

    @device.push_key(:right)
    @player.action.should == :player_moved
    @player.exist?(15, 15).should be_true
    @player.overlap?(@step_down).should be_true

    @device.push_key(:accept_button)
    @player.action.should == :player_step_down

    @device.push_key(:right)
    2.times{@player.action.should == :player_moved}
    @player.exist?(17, 15)
    @player.action.should be_nil
  end

end
