# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')
require File.expand_path(File.dirname(__FILE__) + '/swordman')

describe RDGC::Character::PlayerStatus, "is module of player's status" do

  before do
    @player = Object.new
    @player.extend(RDGC::Character::PlayerStatus)
    @player.change_job(RDGC::Character::Swordman)
  end

  it "initial status" do
    @player.lv.should == 1
    @player.job_name.should == 'Swordman'
    @player.exp.should == 0
    @player.next_lv_exp.should == 6
    @player.rest_exp.should == 6
    @player.exp_ratio.should == 1.0

    @player.str.should == 5
    @player.agi.should == 2
    @player.vit.should == 4
    @player.int.should == 1
    @player.dex.should == 3
    @player.luk.should == 1

    @player.max_hp.should == 20 + 1 + (1.0 * 2.0 * 1.04).ceil
    @player.max_sp.should == 2 + 1 + (1 * 0.2 * 1.01).ceil

    @player.auto_heal_hp.should == 1
    @player.auto_heal_sp.should == 1

    @player.wep_atk.should == 0
    @player.arm_def.should == 0
    @player.view_range.should == 2
    @player.act_cycle.should == 198
    @player.act_ratio.should == 1.0

    @player.hp.should == 0
    @player.sp.should == 0

    @player.timer.cycle.should == 198
    @player.timer.update_ratio.should == 1.0
  end

  it "heal/reduce hp/sp" do
    @player.max_hp.should == 24
    @player.max_sp.should == 4
    @player.hp.should == 0
    @player.sp.should == 0

    @player.full_heal_hp
    @player.hp.should == 24
    @player.reduce_hp(10)
    @player.hp.should == 14
    @player.heal_hp(5)
    @player.hp.should == 19
    @player.reduce_hp(30)
    @player.hp.should == 0
    @player.heal_hp(100)
    @player.hp.should == 24

    @player.full_heal_sp
    @player.sp.should == 4
    @player.reduce_sp(3)
    @player.sp.should == 1
    @player.heal_sp(2)
    @player.sp.should == 3
    @player.reduce_sp(10)
    @player.sp.should == 0
    @player.heal_sp(100)
    @player.sp.should == 4
  end

  it "auto_heal will heal hp/sp at auto_heal_hp/auto_heal_sp value" do
    @player.auto_heal_hp.should == 1
    @player.auto_heal_sp.should == 1

    @player.full_heal_hp
    @player.full_heal_sp
    @player.hp.should == 24
    @player.sp.should == 4

    @player.reduce_hp(3)
    @player.reduce_sp(3)
    @player.hp.should == 21
    @player.sp.should == 1

    @player.auto_heal
    @player.hp.should == 22
    @player.sp.should == 2

    2.times{@player.auto_heal}
    @player.hp.should == 24
    @player.sp.should == 4

    @player.auto_heal
    @player.hp.should == 24
    @player.sp.should == 4
  end

  it "exp and lvup" do
    @player.lv.should == 1
    @player.exp.should == 0
    @player.next_lv_exp.should == 6
    @player.rest_exp.should == 6
    @player.exp_ratio.should == 1.0
    @player.lvup?.should be_false

    @player.add_exp(1)
    @player.exp.should == 1
    @player.rest_exp.should == 5
    @player.lvup?.should be_false

    @player.instance_eval do
      @exp_ratio = 3.0
    end

    @player.exp_ratio.should == 3.0
    @player.add_exp(1)
    @player.exp.should == 4
    @player.rest_exp.should == 2
    @player.lvup?.should be_false

    @player.instance_eval do
      @exp_ratio = 1.0
    end

    @player.exp_ratio.should == 1.0
    @player.add_exp(3)
    @player.exp.should == 7
    @player.rest_exp.should == -1
    @player.lvup?.should be_true

    @player.lvup
    @player.lv.should == 2

    @player.str.should == 6
    @player.agi.should == 2
    @player.vit.should == 4
    @player.int.should == 1
    @player.dex.should == 3
    @player.luk.should == 1

    @player.max_hp.should == 27
    @player.max_sp.should == 5
    @player.hp.should == 27
    @player.sp.should == 5

    3.times{@player.lvup}

    @player.lv.should == 5

    @player.str.should == 7
    @player.agi.should == 3
    @player.vit.should == 6
    @player.int.should == 1
    @player.dex.should == 5
    @player.luk.should == 2

    @player.act_cycle.should == 197

    @player.max_hp.should == 36
    @player.max_sp.should == 9
    @player.hp.should == 36
    @player.sp.should == 9
  end

end
