# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

class Norvice < RDGC::Character::Job
end

class Swordman < RDGC::Character::Job
  job_name_is 'Swordman'

  str_base_is 5.0
  agi_base_is 2.0
  vit_base_is 4.0
  int_base_is 1.0
  dex_base_is 3.0
  luk_base_is 1.0

  hp_base_is 20
  sp_base_is 2

  str_up_ratio_is 0.5
  agi_up_ratio_is 0.3
  vit_up_ratio_is 0.4
  int_up_ratio_is 0.1
  dex_up_ratio_is 0.4
  luk_up_ratio_is 0.2

  hp_up_ratio_is 2.0
  sp_up_ratio_is 0.2

  next_lv_exp_ratio_is 1.5
end

describe RDGC::Character::Job, "is calc base of player's status" do

  it "set each params" do
    Norvice.set_job_name("のび")
    Norvice.job_name.should == "のび"
    Norvice.job_name_is("ノビ")
    Norvice.job_name.should == "ノビ"
    Norvice.job_name = "ノービス"
    Norvice.job_name.should == "ノービス"

    Norvice.next_lv_exp_ratio.should == 1.0
    Norvice.set_next_lv_exp_ratio(1.1)
    Norvice.next_lv_exp_ratio.should == 1.1
    Norvice.next_lv_exp_ratio_is(1.2)
    Norvice.next_lv_exp_ratio.should == 1.2
    Norvice.next_lv_exp_ratio = 1.3
    Norvice.next_lv_exp_ratio.should == 1.3
  end

  it "status_from_lv/next_lv_exp will provides status value for lv" do
    Swordman.job_name.should == 'Swordman'

    fval(Swordman.status_from_lv(:str, 10)).should == 10.0
    fval(Swordman.status_from_lv(:agi, 9)).should == 4.7
    fval(Swordman.status_from_lv(:vit, 8)).should == 7.2
    fval(Swordman.status_from_lv(:int, 7)).should == 1.7
    fval(Swordman.status_from_lv(:dex, 6)).should == 5.4
    fval(Swordman.status_from_lv(:luk, 5)).should == 2.0
    fval(Swordman.status_from_lv(:hp, 4)).should == 28
    fval(Swordman.status_from_lv(:sp, 3)).should == 2.6

    Swordman.next_lv_exp(20).should == 662
  end

  def fval(val)
    format("%.1f", val).to_f
  end

end
