# coding: UTF-8
require File.expand_path(File.dirname(__FILE__) + '../../../spec_helper')

include RDGC::Article

describe RDGC::Article::Base, "is Object on Floor" do

  before do
    @art = create
  end

  it "#set will set coordinate" do
    @art.set(10, 12)

    @art.x.should == 10
    @art.y.should == 12
  end

  it "#invisible/#visible will change visible state" do
    @art.invisible?.should be_false
    @art.visible?.should be_true

    @art.invisible
    @art.invisible?.should be_true
    @art.visible?.should be_false

    @art.visible
    @art.invisible?.should be_false
    @art.visible?.should be_true

    @art.visible(false)
    @art.invisible?.should be_true
    @art.visible?.should be_false

    @art.invisible(false)
    @art.invisible?.should be_false
    @art.visible?.should be_true
  end

  it "#disable/#enable will change alive state" do
    @art.disable?.should be_false
    @art.enable?.should be_true

    @art.disable
    @art.disable?.should be_true
    @art.enable?.should be_false

    @art.enable
    @art.disable?.should be_false
    @art.enable?.should be_true

    @art.enable(false)
    @art.disable?.should be_true
    @art.enable?.should be_false

    @art.disable(false)
    @art.disable?.should be_false
    @art.enable?.should be_true
  end

  it "#exist? will check has coordinate" do
    @art.set(5, 6)
    @art.exist?(5, 6).should be_true
    @art.exist?(6, 6).should be_false

    @art.disable
    @art.exist?(5, 6).should be_false
  end

  it "#overlap? will check other article has same coordinate " do
    @art.set(5, 6)
    other = create
    other.set(5, 6)

    other.overlap?(@art).should be_true
  end

  it "#collision? will check collision other unoverlapable article" do
    @art.set(10, 12)
    @art.overlapable?.should be_true
    @art.enable?.should be_true

    @art.collision?(10, 12).should be_false

    class << @art

      def overlapable?
        false
      end

    end

    @art.overlapable?.should be_false
    @art.collision?(10, 12).should be_true

    @art.collision?(10, 13).should be_false
    @art.collision?(9, 12).should be_false

    @art.disable
    @art.collision?(10, 12).should be_false
    @art.enable
    @art.collision?(10, 12).should be_true
  end

  it "#distance provides distance from coordinate" do
    @art.set(5, 6)
    @art.distance(4, 6).should == 1
    @art.distance(5, 8).should == 2
    @art.distance(0, 0).should == 11
    @art.distance(-1, -1).should == 13
  end

  it "#distance_from provides distance from other article" do
    @art.set(5, 6)

    @art.distance_to(nil).should == 0

    @art.distance_to(create.set(4, 6)).should == 1
    @art.distance_to(create.set(5, 8)).should == 2
    @art.distance_to(create.set(0, 0)).should == 11
    @art.distance_to(create.set(-1, -1)).should == 13
  end

  it "#directions provides directions from coordinate" do
    @art.set(5, 6)

    @art.directions(5, 6).should == [Map::Direction::SELF]
    @art.directions(3, 6).should == [Map::Direction::LEFT]
    @art.directions(10, 6).should == [Map::Direction::RIGHT]
    @art.directions(5, 1).should == [Map::Direction::UPPER]
    @art.directions(5, 8).should == [Map::Direction::BOTTOM]

    ret_lu = @art.directions(3, 4)
    ret_lu.should be_include(Map::Direction::LEFT)
    ret_lu.should be_include(Map::Direction::UPPER)

    ret_lb = @art.directions(4, 7)
    ret_lb.should be_include(Map::Direction::LEFT)
    ret_lb.should be_include(Map::Direction::BOTTOM)

    ret_ru = @art.directions(8, 2)
    ret_ru.should be_include(Map::Direction::RIGHT)
    ret_ru.should be_include(Map::Direction::UPPER)

    ret_rb = @art.directions(6, 9)
    ret_rb.should be_include(Map::Direction::RIGHT)
    ret_rb.should be_include(Map::Direction::BOTTOM)
  end

  it "#directions_from provides directions other article" do
    @art.set(5, 6)

    @art.directions_to(nil).should be_empty

    @art.directions_to(create.set(5, 6)).should == [Map::Direction::SELF]
    @art.directions_to(create.set(3, 6)).should == [Map::Direction::LEFT]
    @art.directions_to(create.set(10, 6)).should == [Map::Direction::RIGHT]
    @art.directions_to(create.set(5, 1)).should == [Map::Direction::UPPER]
    @art.directions_to(create.set(5, 8)).should == [Map::Direction::BOTTOM]

    ret_lu = @art.directions_to(create.set(3, 4))
    ret_lu.should be_include(Map::Direction::LEFT)
    ret_lu.should be_include(Map::Direction::UPPER)

    ret_lb = @art.directions_to(create.set(4, 7))
    ret_lb.should be_include(Map::Direction::LEFT)
    ret_lb.should be_include(Map::Direction::BOTTOM)

    ret_ru = @art.directions_to(create.set(8, 2))
    ret_ru.should be_include(Map::Direction::RIGHT)
    ret_ru.should be_include(Map::Direction::UPPER)

    ret_rb = @art.directions_to(create.set(6, 9))
    ret_rb.should be_include(Map::Direction::RIGHT)
    ret_rb.should be_include(Map::Direction::BOTTOM)
  end

  it "#reaction_to will action to collision article, default do nothing" do
    other = create
    @art.reaction_to(other).should be_nil
  end

  def create
    Article::Base.new
  end

end
