# coding: UTF-8
module ROgue01
  module Monster

    class PinkBigStatusType < RDGC::Monster::MonsterStatusType
      str_base_is 10.0
      agi_base_is 4.0
      vit_base_is 5.0
      int_base_is 1.0
      dex_base_is 6.0
      luk_base_is 1.0

      hp_base_is 50
      sp_base_is 1

      str_up_ratio_is 1.0
      agi_up_ratio_is 0.6
      vit_up_ratio_is 0.5
      int_up_ratio_is 0.1
      dex_up_ratio_is 0.6
      luk_up_ratio_is 0.1

      hp_up_ratio_is 8.0
      sp_up_ratio_is 0.1

      exp_ratio_is 2.0

      view_range_is 5
    end

    class PinkBig < RDGC::Monster::Base
      include RDGC::Monster::ActiveChaseType

      attr_accessor :boss_flag

      monster_name_is '(　･　ω　･　)'
      status_type PinkBigStatusType

      # override
      def monster_action
        return :stay if boss_flag && (distance_to(floor.player) > view_range)
        super
      end

    end

  end
end
