# coding: UTF-8
require 'kconv'
require 'dxruby'

class String

  def conv_sjis
    self.kconv(Kconv::SJIS, Kconv::UTF8)
  end

end

module ROgue01
  class BlockDrawer

    IMG_PATH = File.join(File.dirname(__FILE__), '..', 'dat')

    def initialize
      @v_size = 7
      @block_size = 24
      @font = Font.new(20)
      @mes_font = Font.new(12)
      @floor = Image.new(@block_size, @block_size, [255, 255, 255, 255])
      @unknown = Image.new(@block_size, @block_size, [255, 200, 200, 200])
      @dark = Image.new(@block_size, @block_size, [255, 128, 128, 128])
      @out = Image.new(@block_size, @block_size, [255, 0, 0, 0])
      @wall = Image.new(@block_size, @block_size, [255, 64, 64, 64])
      @player = Image.new(@block_size, @block_size, [255, 255, 0, 0])
      @step_down = Image.new(@block_size, @block_size, [255, 0, 255, 0])
      @step_up = Image.new(@block_size, @block_size, [255, 0, 0, 255])
      @mob_img = Image.load(File.join(IMG_PATH, 'pink.dat'))
    end

    def draw(dm)
      draw_dungeon(dm.floor, dm.player)
      draw_message(dm.player, dm.floor_number)
      draw_status(dm.player)
    end

    private

    def draw_status(pl)
      right = 20 + (@v_size*2+1) * @block_size
      diff = @font.size
      up = 60

      Window.drawFont(right, up+diff*0, "STR:#{pl.str}", @font)
      Window.drawFont(right, up+diff*1, "AGI:#{pl.agi}", @font)
      Window.drawFont(right, up+diff*2, "VIT:#{pl.vit}", @font)
      Window.drawFont(right, up+diff*3, "INT:#{pl.int}", @font)
      Window.drawFont(right, up+diff*4, "DEX:#{pl.dex}", @font)
      Window.drawFont(right, up+diff*5, "LUK:#{pl.luk}", @font)

      Window.drawFont(right, up+diff*7, "ATK:#{pl.atk}", @font)
      Window.drawFont(right, up+diff*8, "DEF:#{pl.pdef}", @font)
    end

    def draw_message(pl, num)
      Window.drawFont(0, 0, "Floor:#{num} #{pl.job_name} HP:#{pl.hp}/#{pl.max_hp} Lv:#{pl.lv}/next:#{pl.rest_exp}", @font)

      right = 20 + (@v_size*2+1) * @block_size
      mes_point = 48 + (@v_size+5) * @block_size

      RDGC::Message::MessageManager.buffer.each do |mes|
        Window.drawFont(right, mes_point, mes.conv_sjis, @mes_font)
        mes_point += @mes_font.size
      end
    end

    def draw_dungeon(fl, pl)
      board = fl.board

      (-@v_size..@v_size).each do |x|
        (-@v_size..@v_size).each do |y|
          t = board.tile(pl.x + x, pl.y + y)
          case
          when t.nil? || t.out?
            i = @out
          when t.wall?
            i = @wall
          else
            if board.visible?(pl.x + x, pl.y + y)
              i = @floor
            elsif board.dark?(pl.x + x, pl.y + y)
              i = @dark
            else
              i = @unknown
            end
          end
          draw_block(x, y, i)

          if board.visible?(pl.x + x, pl.y + y)
            fl.articles_for(pl.x + x, pl.y + y).each do |a|
              case a
              when RDGC::Article::Step
                case
                when a.up?
                  draw_block(x, y, @step_up)
                when a.down?
                  draw_block(x, y, @step_down)
                end
              when ROgue01::Monster::PinkMini
                draw_mini(x, y)
              when ROgue01::Monster::PinkBig
                draw_big(x, y)
              end
            end
          end
        end
      end

      draw_block(0, 0, @player)
    end

    def draw_block(dx, dy, b)
      Window.draw(block_x(dx), block_y(dy), b)
    end

    def draw_mini(dx, dy)
      Window.drawEx(block_x(dx), block_y(dy), @mob_img,
      {:scalex => 1.2, :scaley => 1.2, :z => 1})
    end

    def draw_big(dx, dy)
      Window.drawEx(block_x(dx), block_y(dy), @mob_img,
      {:scalex => 2.0, :scaley => 2.0, :z => 2})
    end

    def block_x(dx)
      left_margin = 10
      left_margin + (@v_size + dx) * @block_size
    end

    def block_y(dy)
      up_margin = 30
      up_margin + (@v_size + dy) * @block_size
    end

  end
end
