# coding: UTF-8
module RDGC
  module Message
    class MessageFactory

      class << self

        DEFAULT_SEP_CHAR = '^'
        DEFAULT_LINE_CHAR = '||'

        def get(mes_type, params = nil)
          params ||= {}
          @mes_hash ||= {}
          @sep_char ||= DEFAULT_SEP_CHAR
          @line_char ||= DEFAULT_LINE_CHAR

          mes = @mes_hash[mes_type]
          return unless mes

          params.each do |k, v|
            mes = mes.gsub("#{@sep_char}#{k}#{@sep_char}", v.to_s)
          end

          mes.split(@line_char)
        end

        private

        def message(mes_type, mes)
          @mes_hash ||= {}
          @mes_hash[mes_type] = mes
        end

        def sep_char(c)
          @sep_char = c
        end

        def line_char(c)
          @line_char = c
        end

      end

    end
  end
end

=begin

:player_step_up => [:player_name, :floor_number]
:player_step_down => [:player_name, :floor_number]
:player_move_floor => [:player_name, :floor_number]
:player_attack_critical => [:player_name, :monster_name, :damage]
:player_attack_hit, => [:player_name, :monster_name, :damage]
:player_attack_miss, => [:player_name, :monster_name]
:player_attack_fumble, => [:player_name, :monster_name]
:player_get_exp => [:player_name, :exp]
:player_lvup => [:player_name, :lv]
:player_dead => [:player_name, :monster_name]
:monstar_attack_critical => [:player_name, :monster_name, :damage]
:monstar_attack_hit => [:player_name, :monster_name, :damage]
:monstar_attack_miss, => [:player_name, :monster_name]
:monstar_attack_fumble, => [:player_name, :monster_name]
:monster_dead => [:player_name, :monster_name]

=end
