# coding: UTF-8
module RDGC
  module Map
    class Floor

      attr_accessor :num, :name

      def self.create_from_board(b)
        f = self.new
        f.set_board(b)
        f
      end

      def board
        @board
      end

      def set_board(b)
        @board = b
        self
      end

      def blocks
        return [] unless board
        board.blocks
      end

      def rooms
        return [] unless board
        board.rooms
      end

      def roads
        return [] unless board
        board.roads
      end

      def areas
        return [] unless board
        board.areas
      end

      def areas_for(x, y)
        return [] unless board
        board.areas_for(x, y)
      end

      def movable?(x, y)
        return unless board
        board.movable?(x, y)
      end

      def room?(x, y)
        return unless board
        board.room?(x, y)
      end

      def road?(x, y)
        return unless board
        board.road?(x, y)
      end

      def articles
        @articles ||= []
        @articles
      end

      def add_article(art)
        return self unless art
        return self if articles.include?(art)
        art.floor = self
        articles << art
        self
      end

      def articles_for(x, y)
        return [] unless board.has_xy?(x, y)
        articles.select{|a| a.exist?(x, y)}
      end

      def overlap_articles_for(art)
        return [] unless art
        articles.select{|a| art.overlap?(a)}
      end

      def collision_articles_for(x, y)
        articles.select{|a| a.collision?(x, y)}
      end

      def clean_articles
        articles.delete_if{|a| a.disable?}
      end

      def player
        @player ||= articles.find{|a| a.kind_of?(Character::Player)}
        @player
      end

      def open_blind
        board.open_blind(player.x, player.y, player.view_range)
      end

      def search(sx, sy, range)
        return [] if range < 0

        # まず範囲で絞る
        targets = articles.select do |a|
          case
          when a.x < sx - range
            false
          when a.x > sx + range
            false
          when a.y < sy - range
            false
          when a.y > sy + range
            false
          else
            true
          end
        end

        # 生きている対象との距離を算出
        targets.select{|a| a.enable? && a.distance(sx, sy) <= range}
      end

    end
  end
end
