# coding: UTF-8
module RDGC
  module Core
    class Scenario

      class << self

        def device(name)
          case name
          when :dxruby
            @device_name = :dxruby
            require 'rdgc/device/device_dxruby'
          end
        end

        def config(conf)
          @config = conf
        end

        def massage(factory)
          @mes_factory = factory
        end

        def init(params = nil)
          @init = params
        end

        def scene(name, scene_class)
          @scene ||= []
          @scene << [name, scene_class]
        end

        def start_scene(name)
          @start_scene = name
        end

        def start(params = nil)
          return unless @scene
          return unless @start_scene

          require 'rdgc/device/device_dxruby' unless @device_name

          Util::Config.set(@config) if @config

          @mes_factory ||= Message::MessageFactory
          Message::MessageManager.set_factory(@mes_factory)

          GameMaster.init(@init) if @init
          @scene.each{|n, s| GameMaster.add_scene(n, s)}

          GameMaster.start(@start_scene, params)
        end
        alias :run :start

      end

    end
  end
end
