# coding: UTF-8
module RDGC
  module Core
    class DungeonMaster

      attr_reader :player, :floor

      def self.create(player, params = nil)
        dm = self.new(player, params)
        dm.prepare
      end

      def initialize(pl, params = nil)
        @player = pl
        @params = params
      end

      def params
        @params ||= {}
        @params
      end

      def floor_number
        @floor_number
      end

      def time_keeper
        @time_keeper ||= TimeKeeper.new
        @time_keeper
      end

      def monster_max_count
        @monster_max_count
      end

      def disable?
        @disable
      end

      def disable(f = true)
        @disable = f
      end

      def prepare
        @floor_number = params[:floor_number]
        @floor = create_floor

        prapare_articles

        monster_density = params[:monster_density]
        monster_density ||= 3.0
        @monster_max_count = (floor.rooms.size * monster_density).ceil

        pop_time = params[:monster_pop_time]
        pop_time ||= (Util::Config.act_max_count * 7.5).ceil

        monstar_init_count = params[:monstar_init_count]
        monstar_init_count ||= range_rand((floor.rooms.size * 0.5).ceil, floor.rooms.size)
        monstar_init_count.to_i.times{add_monster(true)} if monstar_init_count.to_i > 0

        add_timers = params[:add_timers]
        add_timers ||= []

        time_keeper << Timer::MonsterPopTimer.create(pop_time.to_i, self) if pop_time.to_i > 0
        add_timers.each{|t| time_keeper << t}

        self
      end

      def proceed
        # すでに無効な対象をクリア
        floor.clean_articles

        # TimeKeeperが次の対象を決める
        target = time_keeper.next

        # action実行
        rsl = target.action
        return unless rsl

        # 1カウント時間を進める
        time_keeper.update

        # TODO viewを考慮するやり方
        rsl
      end

      def add_article(a)
        floor.add_article(a)
        time_keeper << a.timer if a.kind_of?(Article::TimeControlled)
        self
      end

      def random_point
        tx, ty = nil
        find = false

        10.times do
          tx, ty = floor.rooms.choice.random_point
          next if near_player?(tx, ty)
          next unless floor.articles_for(tx, ty).empty?

          find = true
          break
        end
        return unless find

        [tx, ty]
      end

      def near_player?(tx, ty)
        pl = floor.player
        return false if tx < pl.x - 2
        return false if tx > pl.x + 2
        return false if ty < pl.y - 2
        return false if ty > pl.y + 2
        true
      end

      def add_monster(force = false)
        pop = case
        when force
          true
        when monster_over?
          false
        else
          pop_monster?
        end
        return self unless pop

        co = random_point
        return self unless co

        m = create_monster
        m.set(co.first, co.last)
        add_article(m)
        self
      end

      def monster_count
        floor.articles.select{|a| a.kind_of?(Monster::Base)}.size
      end

      def monster_over?
        return true if monster_max_count <= 0
        monster_count >= monster_max_count ? true : false
      end

      # override if need
      def pop_monster?
        bool_rand
      end

      def prepare_player
        px, py = floor.rooms.choice.random_point
        player.set(px, py)
        player
      end

      def create_floor
        # need override
      end

      def create_monster
        # need override
      end

      def prapare_articles
        # need override
      end

    end
  end
end
