# coding: UTF-8
module RDGC
  module Character
    class Player < Base
      include PlayerStatus

      attr_accessor :player_name
      alias :name :player_name

      def self.create(job)
        return unless job
        player = self.new
        player.extend(Util::Config::battle_roll_module)
        player.change_job(job)
        player.full_heal_hp
        player.full_heal_sp
        player
      end

      # override
      def action
        ret = case
        when Device::In.push_dir_key?
          move_action
        when Device::In.accept_button?
          button_action
        else
          nil
        end

        ret ? "player_#{ret}".to_sym : nil
      end

      def move_action
        rsl = case
        when Device::In.up?
          move(Map::Direction::UPPER)
        when Device::In.down?
          move(Map::Direction::BOTTOM)
        when Device::In.left?
          move(Map::Direction::LEFT)
        when Device::In.right?
          move(Map::Direction::RIGHT)
        else
          nil
        end
        floor.open_blind if rsl == :moved
        rsl
      end

      def button_action
        return unless Device::In.accept_button?

        overs = floor.overlap_articles_for(self)
        return :stay if overs.empty?

        # TODO アイテムを拾う処理等

        # 階段
        step = overs.select{|o| o.kind_of?(Article::Step)}.first
        return :stay unless step

        case
        when step.up?
          :step_up
        when step.down?
          :step_down
        end
      end

      def reaction_to(a)
        return unless a.kind_of?(Monster::Base)
        attacked_from(a)
      end

      # override
      def before_attack(a)
      end

      # override
      def judge_attack_result(d, rsl, val)
        case rsl
        when :critical
          Message::MessageManager.add(:player_attack_critical,
          :player_name => self.name, :monster_name => d.name, :damage => val)
        when :hit
          Message::MessageManager.add(:player_attack_hit,
          :player_name => self.name, :monster_name => d.name, :damage => val)
        when :miss
          Message::MessageManager.add(:player_attack_miss,
          :player_name => self.name, :monster_name => d.name)
        when :fumble
          Message::MessageManager.add(:player_attack_fumble,
          :player_name => self.name, :monster_name => d.name)
        end

        val
      end

      # override
      def after_attack(d, rsl, val)
      end

      # override
      def close_attack(d)
        return unless d.disable?

        exp = self.add_exp(d.exp)
        Message::MessageManager.add(:monster_dead,
        :player_name => self.name, :monster_name => d.name)
        Message::MessageManager.add(:player_get_exp,
        :player_name => self.name, :exp => exp)
        return unless lvup?
        self.lvup
        Message::MessageManager.add(:player_lvup,
        :player_name => self.name, :lv => self.lv)
      end

    end
  end
end
