# coding: UTF-8
module RDGC
  module Timer
    module Base

      attr_reader :cycle, :limit

      def cycle=(count)
        return unless count
        return if count.to_i <= 0
        @cycle = count.to_i
      end

      def limit=(count)
        return unless count
        return if count.to_i <= 0
        @limit = count.to_i
      end

      def update_ratio=(ratio)
        return unless ratio
        return if ratio.to_f <= 0.0
        @update_ratio = ratio
      end

      def update_ratio
        @update_ratio ||= 1.0
        @update_ratio
      end

      def cycle_type?
        return false unless cycle
        cycle > 0 ? true : false
      end

      def limit_type?
        return false unless limit
        limit > 0 ? true : false
      end

      def pass_time
        @pass_time ||= 0.0
        @pass_time
      end

      def cycle_time
        @cycle_time ||= 0.0
        @cycle_time
      end

      def update(count = 1)
        return unless count
        return if count.to_i <= 0
        up = count.to_f * update_ratio.to_f
        update_cycle(up)
        update_limit(up)
      end

      def reset_cycle
        @cycle_time = cycle_type? ? 0.0 : nil
      end

      def reset
        @pass_time = limit_type? ? 0.0 : nil
        reset_cycle
      end

      def cycle_arrive?
        return false unless cycle_type?
        cycle_time >= cycle.to_f ? true : false
      end

      def limit_arrive?
        return false unless limit_type?
        pass_time >= limit.to_f ? true : false
      end

      def action_ok?
        case
        when cycle_type?
          cycle_arrive?
        when limit_type?
          limit_arrive?
        else
          false
        end
      end

      def finish?
        return false unless limit_type?
        limit_arrive?
      end

      def next_time
        case
        when cycle_type?
          cycle.to_f - cycle_time
        when limit_type?
          limit.to_f - pass_time
        end
      end

      def next_count
        (next_time.to_f / update_ratio.to_f).ceil
      end

      def action
        return unless action_ok?
        rsl = do_action
        reset_cycle if cycle_type? && rsl
        rsl
      end

      def do_action
        # need override
        true
      end

      private

      def update_cycle(up)
        return unless cycle_type?
        @cycle_time ||= 0.0
        @cycle_time += up
      end

      def update_limit(up)
        return unless limit_type?
        @pass_time ||= 0.0
        @pass_time += up
      end

    end
  end
end
