# coding: UTF-8
module RDGC
  module Timer
    class CallbackTimer
      include Base

      attr_accessor :target, :call_method, :args, :result

      def disable?
        return true unless self.target
        return true unless self.respond_to?(:disable?)
        self.target.disable? ? true : false
      end

      def do_action
        return unless self.target
        return unless self.target.respond_to?(self.call_method.to_sym)

        ret = if self.args
          self.target.__send__(self.call_method.to_sym, *self.args)
        else
          self.target.__send__(self.call_method.to_sym)
        end

        result ? result : ret
      end

    end
  end
end
