# coding: UTF-8
module RDGC
  module Scene

    class Base

      def init
      end

      def run
      end

      def render
      end

      def turn_to(scene_class)
        @manager.turn_to(scene_class)
      end

      def finish
        @manager.finish
      end

      def params
        @manager.params
      end

      def start(manager)
        @manager = manager
        init
      end

      def destory
        @manager = nil
      end

    end

    class Manager

      def self.start_from(scene_class, default_param = nil)
        man = self.new(scene_class, default_param)
        man.run
      end

      def initialize(scene_class, default_param = nil)
        @param = default_param
        turn(scene_class)
      end

      def params
        @param ||= {}
        @param
      end

      def turn_to(scene_class)
        @mode = :turn
        @next = scene_class
      end

      def finish
        @mode = :finish
        @next = nil
      end

      def turn(scene_class = nil)
        scene_class ||= @next
        return unless scene_class

        @scene.destory if @scene
        @scene = scene_class.new
        @scene.start(self)

        @mode = :run
        @next = nil
      end

      def run
        Window.loop do
          @scene.run
          @scene.render

          case @mode
          when :finish
            break
          when :turn
            turn
          end
        end
      end

    end

  end
end
