# coding: UTF-8
module RDGC
  module Scene
    class GameMaster

      attr_reader :dungeon, :player, :floor, :params

      def self.start_for(player, floor, params = nil)
        master = self.new
        params ||= {}

        master.instance_eval do
          @player = player
          @floor = floor
          @params = params
          create_floor
          crear_massages
        end

        master
      end

      def proceed
        rsl =  @dungeon.proceed
        judge(rsl)
        rsl
      end

      def create_floor
        @floor ||= 1
        @dungeon = produce_dungeon
      end

      def create_next_floor
        @floor ||= 0
        @floor += 1
        create_floor
      end

      def crear_massages
        Messages.clear
      end

      def judge(act_rsl)
        case act_rsl
        when :player_step_down
          create_next_floor
          Messages << "階段を下りました"
          Messages << "Floor:#{@floor}"
        end
      end

      def move_floor_to(floor)
        @floor = floor
        create_floor
      end

      def gameover?
        @player.disable?
      end

      def produce_dungeon
      end

    end
  end
end
