# coding: UTF-8
module RDGC
  module Monster
    module MonsterActionBase

      def action
        ret = monster_action

        # 必ず何かを実行したことにする
        ret ? "monster_#{ret}".to_sym : :monster_action
      end

      def monster_action
        # need override
      end

      def movable_to?(dir)
        return false unless dir
        floor.movable?(self.x + dir.x, self.y + dir.y)
      end

      def chase_miss_count
        @chase_miss_count ||= 0
        @chase_miss_count
      end

      def add_miss_count
        @chase_miss_count ||= 0
        @chase_miss_count += 1
      end

      def clear_miss_count
        @chase_miss_count = 0
      end

      # override if need
      def select_target(list)
        # とりあえずプレイヤーを探す
        [list].flatten.find{|a| a.kind_of?(Character::Player)}
      end

      def random_move
        dir_list = Map::Direction.each.select{|d| movable_to?(d)}
        move([dir_list, Map::Direction::SELF].flatten.compact.choice)
      end

      def chase_move
        # 対象を探す
        list = floor.search(self.x, self.y, view_range)
        target = select_target(list)

        unless target
          # 興味のある対象がいない
          add_miss_count
          return random_move
        end

        # 隣接するarticlesを取得
        list.delete(target)
        arounds = list.select{|a| distance_to(a) == 1 && ! a.overlapable?}
        ng_dir = arounds.map{|a| directions_to(a)}.flatten.uniq

        # 移動方向選択
        dirs = (directions_to(target) - ng_dir).select{|d| movable_to?(d)}
        if dirs.empty?
          # 追いかけたい対象の方へ移動できない
          add_miss_count
          random_move
        else
          # 対象に向かって移動
          clear_miss_count
          move(dirs.choice)
        end
      end

    end
  end
end
