# coding: UTF-8
module RDGC
  module Message
    class MessageManager

      class << self

        def set_factory(f)
          @factory = f
        end

        def factory
          @factory
        end

        def add(mes_type, params = nil)
          mes = factory.get(mes_type.to_sym, params)
          return unless mes
          [mes].flatten.each{|m| push m}
        end

        def push(mes)
          buffer << mes
          return if buffer.size <= Util::Config.message_buffer_size
          max = buffer.size
          max.times do
            break if buffer.size <= Util::Config.message_buffer_size
            buffer.shift
          end
        end
        alias :<< :push

        def buffer
          @buffer ||= []
          @buffer
        end

        def clear
          @buffer = []
        end

      end

    end
  end
end
